/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.logging.LogProvider;

public class DynamicArrayStore
extends AbstractDynamicStore {
    public static final int NUMBER_HEADER_SIZE = 3;
    public static final int STRING_HEADER_SIZE = 5;
    public static final String TYPE_DESCRIPTOR = "ArrayPropertyStore";

    public DynamicArrayStore(File fileName, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, int dataSizeFromConfiguration, RecordFormat<DynamicRecord> recordFormat, String storeVersion, OpenOption ... openOptions) {
        super(fileName, configuration, idType, idGeneratorFactory, pageCache, logProvider, TYPE_DESCRIPTOR, dataSizeFromConfiguration, recordFormat, storeVersion, openOptions);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, DynamicRecord record) throws FAILURE {
        processor.processArray(this, record);
    }

    public static void allocateFromNumbers(Collection<DynamicRecord> target, Object array, Iterator<DynamicRecord> recordsToUseFirst, DynamicRecordAllocator recordAllocator) {
        byte[] bytes2;
        Class<?> componentType = array.getClass().getComponentType();
        boolean isPrimitiveByteArray = componentType.equals(Byte.TYPE);
        boolean isByteArray = componentType.equals(Byte.class) || isPrimitiveByteArray;
        ShortArray type = ShortArray.typeOf(array);
        if (type == null) {
            throw new IllegalArgumentException(array + " not a valid array type.");
        }
        int arrayLength = Array.getLength(array);
        int requiredBits = isByteArray ? 8 : type.calculateRequiredBitsForArray(array, arrayLength);
        int totalBits = requiredBits * arrayLength;
        int numberOfBytes = (totalBits - 1) / 8 + 1;
        int bitsUsedInLastByte = totalBits % 8;
        bitsUsedInLastByte = bitsUsedInLastByte == 0 ? 8 : bitsUsedInLastByte;
        numberOfBytes += 3;
        if (isByteArray) {
            bytes2 = new byte[3 + arrayLength];
            bytes2[0] = (byte)type.intValue();
            bytes2[1] = (byte)bitsUsedInLastByte;
            bytes2[2] = (byte)requiredBits;
            if (isPrimitiveByteArray) {
                System.arraycopy(array, 0, bytes2, 3, arrayLength);
            } else {
                Byte[] source = (Byte[])array;
                for (int i = 0; i < source.length; ++i) {
                    bytes2[3 + i] = source[i];
                }
            }
        } else {
            Bits bits2 = Bits.bits(numberOfBytes);
            bits2.put((byte)type.intValue());
            bits2.put((byte)bitsUsedInLastByte);
            bits2.put((byte)requiredBits);
            type.writeAll(array, arrayLength, requiredBits, bits2);
            bytes2 = bits2.asBytes();
        }
        DynamicArrayStore.allocateRecordsFromBytes(target, bytes2, recordsToUseFirst, recordAllocator);
    }

    private static void allocateFromString(Collection<DynamicRecord> target, String[] array, Iterator<DynamicRecord> recordsToUseFirst, DynamicRecordAllocator recordAllocator) {
        byte[][] stringsAsBytes = new byte[array.length][];
        int totalBytesRequired = 5;
        for (int i = 0; i < array.length; ++i) {
            String string2 = array[i];
            byte[] bytes2 = PropertyStore.encodeString(string2);
            stringsAsBytes[i] = bytes2;
            totalBytesRequired += 4 + bytes2.length;
        }
        ByteBuffer buf = ByteBuffer.allocate(totalBytesRequired);
        buf.put(PropertyType.STRING.byteValue());
        buf.putInt(array.length);
        for (byte[] stringAsBytes : stringsAsBytes) {
            buf.putInt(stringAsBytes.length);
            buf.put(stringAsBytes);
        }
        DynamicArrayStore.allocateRecordsFromBytes(target, buf.array(), recordsToUseFirst, recordAllocator);
    }

    public void allocateRecords(Collection<DynamicRecord> target, Object array, Iterator<DynamicRecord> recordsToUseFirst) {
        DynamicArrayStore.allocateRecords(target, array, recordsToUseFirst, this);
    }

    public static void allocateRecords(Collection<DynamicRecord> target, Object array, Iterator<DynamicRecord> recordsToUseFirst, DynamicRecordAllocator recordAllocator) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException(array + " not an array");
        }
        Class<?> type = array.getClass().getComponentType();
        if (type.equals(String.class)) {
            DynamicArrayStore.allocateFromString(target, (String[])array, recordsToUseFirst, recordAllocator);
        } else {
            DynamicArrayStore.allocateFromNumbers(target, array, recordsToUseFirst, recordAllocator);
        }
    }

    public static Object getRightArray(Pair<byte[], byte[]> data) {
        Object result2;
        byte[] header = data.first();
        byte[] bArray = data.other();
        byte typeId = header[0];
        if (typeId == PropertyType.STRING.intValue()) {
            ByteBuffer headerBuffer = ByteBuffer.wrap(header, 1, header.length - 1);
            int arrayLength = headerBuffer.getInt();
            String[] result3 = new String[arrayLength];
            ByteBuffer dataBuffer = ByteBuffer.wrap(bArray);
            for (int i = 0; i < arrayLength; ++i) {
                int byteLength = dataBuffer.getInt();
                byte[] stringByteArray = new byte[byteLength];
                dataBuffer.get(stringByteArray);
                result3[i] = PropertyStore.decodeString(stringByteArray);
            }
            return result3;
        }
        ShortArray type = ShortArray.typeOf(typeId);
        byte bitsUsedInLastByte = header[1];
        byte requiredBits = header[2];
        if (requiredBits == 0) {
            return type.createEmptyArray();
        }
        if (type == ShortArray.BYTE && requiredBits == 8) {
            result2 = bArray;
        } else {
            Bits bits2 = Bits.bitsFromBytes(bArray);
            int length2 = (bArray.length * 8 - (8 - bitsUsedInLastByte)) / requiredBits;
            result2 = type.createArray(length2, bits2, requiredBits);
        }
        return result2;
    }

    public Object getArrayFor(Iterable<DynamicRecord> records) {
        return DynamicArrayStore.getRightArray(this.readFullByteArray(records, PropertyType.ARRAY));
    }
}

