/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.Neo4jTypes;

public class TypeMappers {
    private final Map<Type, NeoValueConverter> javaToNeo = new HashMap<Type, NeoValueConverter>();
    private final NeoValueConverter TO_ANY = new SimpleConverter(Neo4jTypes.NTAny, Object.class);
    private final NeoValueConverter TO_STRING = new SimpleConverter(Neo4jTypes.NTString, String.class);
    private final NeoValueConverter TO_INTEGER = new SimpleConverter(Neo4jTypes.NTInteger, Long.class);
    private final NeoValueConverter TO_FLOAT = new SimpleConverter(Neo4jTypes.NTFloat, Double.class);
    private final NeoValueConverter TO_NUMBER = new SimpleConverter(Neo4jTypes.NTNumber, Number.class);
    private final NeoValueConverter TO_BOOLEAN = new SimpleConverter(Neo4jTypes.NTBoolean, Boolean.class);
    private final NeoValueConverter TO_MAP = new SimpleConverter(Neo4jTypes.NTMap, Map.class);
    private final NeoValueConverter TO_LIST = this.toList(this.TO_ANY);

    public TypeMappers() {
        this.registerScalarsAndCollections();
    }

    private void registerScalarsAndCollections() {
        this.registerType(String.class, this.TO_STRING);
        this.registerType(Long.TYPE, this.TO_INTEGER);
        this.registerType(Long.class, this.TO_INTEGER);
        this.registerType(Double.TYPE, this.TO_FLOAT);
        this.registerType(Double.class, this.TO_FLOAT);
        this.registerType(Number.class, this.TO_NUMBER);
        this.registerType(Boolean.TYPE, this.TO_BOOLEAN);
        this.registerType(Boolean.class, this.TO_BOOLEAN);
        this.registerType(Map.class, this.TO_MAP);
        this.registerType(List.class, this.TO_LIST);
        this.registerType(Object.class, this.TO_ANY);
    }

    public Neo4jTypes.AnyType neoTypeFor(Type javaType) throws ProcedureException {
        return this.converterFor(javaType).type();
    }

    public NeoValueConverter converterFor(Type javaType) throws ProcedureException {
        NeoValueConverter converter = this.javaToNeo.get(javaType);
        if (converter != null) {
            return converter;
        }
        if (javaType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)javaType;
            Type rawType = pt.getRawType();
            if (rawType == List.class) {
                return this.toList(this.converterFor(pt.getActualTypeArguments()[0]));
            }
            if (rawType == Map.class) {
                Type type = pt.getActualTypeArguments()[0];
                if (type != String.class) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Maps are required to have `String` keys - but this map has `%s` keys.", type.getTypeName());
                }
                return this.TO_MAP;
            }
        }
        throw this.javaToNeoMappingError(javaType);
    }

    public void registerType(Class<?> javaClass, NeoValueConverter toNeo) {
        this.javaToNeo.put(javaClass, toNeo);
    }

    private NeoValueConverter toList(NeoValueConverter inner2) {
        return new SimpleConverter(Neo4jTypes.NTList(inner2.type()), List.class);
    }

    private ProcedureException javaToNeoMappingError(Type cls) {
        List<Type> types2 = Iterables.asList(this.javaToNeo.keySet());
        types2.sort((a, b) -> a.toString().compareTo(b.toString()));
        return new ProcedureException((Status)Status.Statement.TypeError, "Don't know how to map `%s` to the Neo4j Type System.%nPlease refer to to the documentation for full details.%nFor your reference, known types are: %s", cls, types2);
    }

    public static class SimpleConverter
    implements NeoValueConverter {
        private final Neo4jTypes.AnyType type;
        private final Class<?> javaClass;

        public SimpleConverter(Neo4jTypes.AnyType type, Class<?> javaClass) {
            this.type = type;
            this.javaClass = javaClass;
        }

        @Override
        public Neo4jTypes.AnyType type() {
            return this.type;
        }

        @Override
        public Object toNeoValue(Object javaValue2) throws ProcedureException {
            if (javaValue2 == null || this.javaClass.isInstance(javaValue2)) {
                return javaValue2;
            }
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Expected `%s` to be a `%s`, found `%s`.", javaValue2, this.javaClass.getSimpleName(), javaValue2.getClass());
        }
    }

    static interface NeoValueConverter {
        public Neo4jTypes.AnyType type();

        public Object toNeoValue(Object var1) throws ProcedureException;
    }
}

