/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.impl.proc.TypeMappers;

public class OutputMappers {
    public static OutputMapper VOID_MAPPER = new OutputMapper(new ProcedureSignature.FieldSignature[0], new FieldMapper[0]){

        @Override
        public List<ProcedureSignature.FieldSignature> signature() {
            return ProcedureSignature.VOID;
        }
    };
    private final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private final TypeMappers typeMappers;

    public OutputMappers(TypeMappers typeMappers) {
        this.typeMappers = typeMappers;
    }

    public OutputMapper mapper(Method method) throws ProcedureException {
        Class<?> cls = method.getReturnType();
        if (cls == Void.class || cls == Void.TYPE) {
            return VOID_MAPPER;
        }
        if (cls != Stream.class) {
            throw this.invalidReturnType(cls);
        }
        Type genericReturnType = method.getGenericReturnType();
        if (!(genericReturnType instanceof ParameterizedType)) {
            throw new ProcedureException((Status)Status.Procedure.TypeError, "Procedures must return a Stream of records, where a record is a concrete class%nthat you define and not a raw Stream.", new Object[0]);
        }
        ParameterizedType genType = (ParameterizedType)genericReturnType;
        Type recordType = genType.getActualTypeArguments()[0];
        if (recordType instanceof WildcardType) {
            throw new ProcedureException((Status)Status.Procedure.TypeError, "Procedures must return a Stream of records, where a record is a concrete class%nthat you define and not a Stream<?>.", new Object[0]);
        }
        if (recordType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)recordType;
            throw new ProcedureException((Status)Status.Procedure.TypeError, "Procedures must return a Stream of records, where a record is a concrete class%nthat you define and not a parameterized type such as %s.", type);
        }
        return this.mapper((Class)recordType);
    }

    public OutputMapper mapper(Class<?> userClass) throws ProcedureException {
        this.assertIsValidRecordClass(userClass);
        List<Field> fields = this.instanceFields(userClass);
        ProcedureSignature.FieldSignature[] signature = new ProcedureSignature.FieldSignature[fields.size()];
        FieldMapper[] fieldMappers = new FieldMapper[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            Field field2 = fields.get(i);
            if (!Modifier.isPublic(field2.getModifiers())) {
                throw new ProcedureException((Status)Status.Procedure.TypeError, "Field `%s` in record `%s` cannot be accessed. Please ensure the field is marked as `public`.", field2.getName(), userClass.getSimpleName());
            }
            try {
                FieldMapper fieldMapper;
                TypeMappers.NeoValueConverter mapper = this.typeMappers.converterFor(field2.getGenericType());
                MethodHandle getter2 = this.lookup.unreflectGetter(field2);
                fieldMappers[i] = fieldMapper = new FieldMapper(getter2, mapper);
                signature[i] = new ProcedureSignature.FieldSignature(field2.getName(), mapper.type());
                continue;
            }
            catch (ProcedureException e) {
                throw new ProcedureException(e.status(), (Throwable)e, "Field `%s` in record `%s` cannot be converted to a Neo4j type: %s", field2.getName(), userClass.getSimpleName(), e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new ProcedureException((Status)Status.Procedure.TypeError, (Throwable)e, "Field `%s` in record `%s` cannot be accessed: %s", field2.getName(), userClass.getSimpleName(), e.getMessage());
            }
        }
        return new OutputMapper(signature, fieldMappers);
    }

    private void assertIsValidRecordClass(Class<?> userClass) throws ProcedureException {
        if (userClass.isPrimitive() || userClass.isArray() || userClass.getPackage() != null && userClass.getPackage().getName().startsWith("java.")) {
            throw this.invalidReturnType(userClass);
        }
    }

    private ProcedureException invalidReturnType(Class<?> userClass) {
        return new ProcedureException((Status)Status.Procedure.TypeError, "Procedures must return a Stream of records, where a record is a concrete class%nthat you define, with public non-final fields defining the fields in the record.%nIf you''d like your procedure to return `%s`, you could define a record class like:%npublic class Output '{'%n    public %s out;%n'}'%n%nAnd then define your procedure as returning `Stream<Output>`.", userClass.getSimpleName(), userClass.getSimpleName());
    }

    private List<Field> instanceFields(Class<?> userClass) {
        return Arrays.asList(userClass.getDeclaredFields()).stream().filter(f -> !Modifier.isStatic(f.getModifiers()) && !f.isSynthetic()).collect(Collectors.toList());
    }

    private static class FieldMapper {
        private final MethodHandle getter;
        private final TypeMappers.NeoValueConverter mapper;

        public FieldMapper(MethodHandle getter2, TypeMappers.NeoValueConverter mapper) {
            this.getter = getter2;
            this.mapper = mapper;
        }

        Object apply(Object record) throws ProcedureException {
            Object invoke = this.getValue(record);
            return this.mapper.toNeoValue(invoke);
        }

        private Object getValue(Object record) throws ProcedureException {
            try {
                return this.getter.invoke(record);
            }
            catch (Throwable throwable) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Unable to read value from record `%s`: %s", record, throwable.getMessage());
            }
        }
    }

    public static class OutputMapper {
        private final List<ProcedureSignature.FieldSignature> signature;
        private final FieldMapper[] fieldMappers;

        public OutputMapper(ProcedureSignature.FieldSignature[] signature, FieldMapper[] fieldMappers) {
            this.signature = Arrays.asList(signature);
            this.fieldMappers = fieldMappers;
        }

        public List<ProcedureSignature.FieldSignature> signature() {
            return this.signature;
        }

        public Object[] apply(Object record) throws ProcedureException {
            Object[] output = new Object[this.fieldMappers.length];
            for (int i = 0; i < this.fieldMappers.length; ++i) {
                output[i] = this.fieldMappers[i].apply(record);
            }
            return output;
        }
    }
}

