/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.procedure.Name;

public class MethodSignatureCompiler {
    private final TypeMappers typeMappers;

    public MethodSignatureCompiler(TypeMappers typeMappers) {
        this.typeMappers = typeMappers;
    }

    public List<ProcedureSignature.FieldSignature> signatureFor(Method method) throws ProcedureException {
        Parameter[] params2 = method.getParameters();
        Type[] types2 = method.getGenericParameterTypes();
        ArrayList<ProcedureSignature.FieldSignature> signature = new ArrayList<ProcedureSignature.FieldSignature>(params2.length);
        for (int i = 0; i < params2.length; ++i) {
            Parameter param2 = params2[i];
            Type type = types2[i];
            if (!param2.isAnnotationPresent(Name.class)) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Argument at position %d in method `%s` is missing an `@%s` annotation.%nPlease add the annotation, recompile the class and try again.", i, method.getName(), Name.class.getSimpleName());
            }
            String name2 = param2.getAnnotation(Name.class).value();
            if (name2.trim().length() == 0) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Argument at position %d in method `%s` is annotated with a name,%nbut the name is empty, please provide a non-empty name for the argument.", i, method.getName());
            }
            try {
                signature.add(new ProcedureSignature.FieldSignature(name2, this.typeMappers.neoTypeFor(type)));
                continue;
            }
            catch (ProcedureException e) {
                throw new ProcedureException(e.status(), "Argument `%s` at position %d in `%s` with%ntype `%s` cannot be converted to a Neo4j type: %s", name2, i, method.getName(), param2.getType().getSimpleName(), e.getMessage());
            }
        }
        return signature;
    }
}

