/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.function.LongFunction;
import java.util.function.Supplier;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.impl.core.RelationshipProxy;

public class StandardRelationshipActions
implements RelationshipProxy.RelationshipActions {
    private final Supplier<Statement> stmt;
    private final Supplier<KernelTransaction> currentTransaction;
    private final ThrowingAction<RuntimeException> assertInOpenTransaction;
    private final LongFunction<Node> newNodeProxy;
    private final GraphDatabaseService gds;

    public StandardRelationshipActions(Supplier<Statement> stmt, Supplier<KernelTransaction> currentTransaction, ThrowingAction<RuntimeException> assertInOpenTransaction, LongFunction<Node> newNodeProxy, GraphDatabaseService gds) {
        this.stmt = stmt;
        this.currentTransaction = currentTransaction;
        this.assertInOpenTransaction = assertInOpenTransaction;
        this.newNodeProxy = newNodeProxy;
        this.gds = gds;
    }

    @Override
    public Statement statement() {
        return this.stmt.get();
    }

    @Override
    public Node newNodeProxy(long nodeId) {
        return this.newNodeProxy.apply(nodeId);
    }

    @Override
    public RelationshipType getRelationshipTypeById(int type) {
        try {
            return RelationshipType.withName(this.statement().readOperations().relationshipTypeGetName(type));
        }
        catch (RelationshipTypeIdNotFoundKernelException e) {
            throw new IllegalStateException("Kernel API returned non-existent relationship type: " + type);
        }
    }

    @Override
    public GraphDatabaseService getGraphDatabaseService() {
        return this.gds;
    }

    @Override
    public void failTransaction() {
        this.currentTransaction.get().failure();
    }

    @Override
    public void assertInUnterminatedTransaction() {
        this.assertInOpenTransaction.apply();
    }
}

