/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.function.Supplier;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.ResourceType;

public class PropertyContainerLocker {
    public Lock exclusiveLock(Supplier<Statement> stmtSupplier, PropertyContainer container) {
        Throwable throwable = null;
        try (Statement statement = stmtSupplier.get();){
            if (container instanceof Node) {
                statement.readOperations().acquireExclusive(ResourceTypes.NODE, ((Node)container).getId());
                CoreAPILock coreAPILock = new CoreAPILock(stmtSupplier, ResourceTypes.NODE, ((Node)container).getId()){

                    @Override
                    void release(Statement statement, ResourceType type, long resourceId) {
                        statement.readOperations().releaseExclusive(type, resourceId);
                    }
                };
                return coreAPILock;
            }
            if (container instanceof Relationship) {
                statement.readOperations().acquireExclusive(ResourceTypes.RELATIONSHIP, ((Relationship)container).getId());
                CoreAPILock coreAPILock = new CoreAPILock(stmtSupplier, ResourceTypes.RELATIONSHIP, ((Relationship)container).getId()){

                    @Override
                    void release(Statement statement, ResourceType type, long resourceId) {
                        statement.readOperations().releaseExclusive(type, resourceId);
                    }
                };
                return coreAPILock;
            }
            try {
                throw new UnsupportedOperationException("Only relationships and nodes can be locked.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Lock exclusiveLock(Statement statement, PropertyContainer container) {
        if (container instanceof Node) {
            statement.readOperations().acquireExclusive(ResourceTypes.NODE, ((Node)container).getId());
            return () -> {
                long id = ((Node)container).getId();
                statement.readOperations().releaseExclusive(ResourceTypes.NODE, id);
            };
        }
        if (container instanceof Relationship) {
            statement.readOperations().acquireExclusive(ResourceTypes.RELATIONSHIP, ((Relationship)container).getId());
            return () -> {
                long id = ((Relationship)container).getId();
                statement.readOperations().releaseExclusive(ResourceTypes.RELATIONSHIP, id);
            };
        }
        throw new UnsupportedOperationException("Only relationships and nodes can be locked.");
    }

    public Lock sharedLock(Supplier<Statement> stmtProvider, PropertyContainer container) {
        Throwable throwable = null;
        try (Statement statement = stmtProvider.get();){
            if (container instanceof Node) {
                statement.readOperations().acquireShared(ResourceTypes.NODE, ((Node)container).getId());
                CoreAPILock coreAPILock = new CoreAPILock(stmtProvider, ResourceTypes.NODE, ((Node)container).getId()){

                    @Override
                    void release(Statement statement, ResourceType type, long resourceId) {
                        statement.readOperations().releaseShared(type, resourceId);
                    }
                };
                return coreAPILock;
            }
            if (container instanceof Relationship) {
                statement.readOperations().acquireShared(ResourceTypes.RELATIONSHIP, ((Relationship)container).getId());
                CoreAPILock coreAPILock = new CoreAPILock(stmtProvider, ResourceTypes.RELATIONSHIP, ((Relationship)container).getId()){

                    @Override
                    void release(Statement statement, ResourceType type, long resourceId) {
                        statement.readOperations().releaseShared(type, resourceId);
                    }
                };
                return coreAPILock;
            }
            try {
                throw new UnsupportedOperationException("Only relationships and nodes can be locked.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static abstract class CoreAPILock
    implements Lock {
        private final Supplier<Statement> stmtProvider;
        private final ResourceType type;
        private final long resourceId;
        private boolean released = false;

        public CoreAPILock(Supplier<Statement> stmtProvider, ResourceType type, long resourceId) {
            this.stmtProvider = stmtProvider;
            this.type = type;
            this.resourceId = resourceId;
        }

        @Override
        public void release() {
            if (this.released) {
                throw new IllegalStateException("Already released");
            }
            this.released = true;
            try (Statement statement = this.stmtProvider.get();){
                this.release(statement, this.type, this.resourceId);
            }
        }

        abstract void release(Statement var1, ResourceType var2, long var3);
    }
}

