/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.function.Supplier;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;

public class PlaceboTransaction
implements InternalTransaction {
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private final Supplier<Statement> stmt;
    private final Supplier<KernelTransaction> currentTransaction;
    private boolean success;

    public PlaceboTransaction(Supplier<KernelTransaction> currentTransaction, Supplier<Statement> stmt) {
        this.stmt = stmt;
        this.currentTransaction = currentTransaction;
    }

    @Override
    public void terminate() {
        this.currentTransaction.get().markForTermination(Status.Transaction.Terminated);
    }

    @Override
    public void failure() {
        this.currentTransaction.get().failure();
    }

    @Override
    public void success() {
        this.success = true;
    }

    @Override
    public void close() {
        if (!this.success) {
            this.currentTransaction.get().failure();
        }
    }

    @Override
    public Lock acquireWriteLock(PropertyContainer entity) {
        return locker.exclusiveLock(this.stmt, entity);
    }

    @Override
    public Lock acquireReadLock(PropertyContainer entity) {
        return locker.sharedLock(this.stmt, entity);
    }

    @Override
    public KernelTransaction.Type transactionType() {
        return this.currentTransaction.get().transactionType();
    }

    @Override
    public AccessMode mode() {
        return this.currentTransaction.get().mode();
    }

    @Override
    public KernelTransaction.Revertable restrict(AccessMode mode) {
        return this.currentTransaction.get().restrict(mode);
    }
}

