/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.kernel.api.legacyindex.AutoIndexOperations;

public class AutoIndexerFacade<T extends PropertyContainer>
implements AutoIndexer<T> {
    private final Supplier<ReadableIndex<T>> indexProvider;
    private final AutoIndexOperations autoIndexing;

    public AutoIndexerFacade(Supplier<ReadableIndex<T>> indexProvider, AutoIndexOperations autoIndexing) {
        this.indexProvider = indexProvider;
        this.autoIndexing = autoIndexing;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.autoIndexing.enabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.autoIndexing.enabled();
    }

    @Override
    public ReadableIndex<T> getAutoIndex() {
        return this.indexProvider.get();
    }

    @Override
    public void startAutoIndexingProperty(String propName) {
        this.autoIndexing.startAutoIndexingProperty(propName);
    }

    @Override
    public void stopAutoIndexingProperty(String propName) {
        this.autoIndexing.stopAutoIndexingProperty(propName);
    }

    @Override
    public Set<String> getAutoIndexedProperties() {
        return this.autoIndexing.getAutoIndexedProperties();
    }
}

