/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.AutoIndexingKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.core.PropertyContainerProxy;
import org.neo4j.kernel.impl.core.RelationshipConversion;
import org.neo4j.storageengine.api.EntityType;

public class NodeProxy
extends PropertyContainerProxy
implements Node {
    private final NodeActions actions;
    private final long nodeId;

    public NodeProxy(NodeActions actions, long nodeId) {
        this.nodeId = nodeId;
        this.actions = actions;
    }

    @Override
    public long getId() {
        return this.nodeId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.actions.getGraphDatabase();
    }

    @Override
    public void delete() {
        try (Statement statement = this.actions.statement();){
            statement.dataWriteOperations().nodeDelete(this.getId());
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Unable to delete Node[" + this.nodeId + "] since it has already been deleted.");
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while deleting the node: " + e.getMessage(), e);
        }
    }

    public ResourceIterable<Relationship> getRelationships() {
        return this.getRelationships(Direction.BOTH);
    }

    public ResourceIterable<Relationship> getRelationships(Direction dir) {
        this.assertInUnterminatedTransaction();
        return () -> {
            Statement statement = this.actions.statement();
            try {
                RelationshipConversion result2 = new RelationshipConversion(this.actions);
                result2.iterator = statement.readOperations().nodeGetRelationships(this.nodeId, dir);
                result2.statement = statement;
                return result2;
            }
            catch (EntityNotFoundException e) {
                statement.close();
                throw new NotFoundException(String.format("Node %d not found", this.nodeId), e);
            }
            catch (Throwable e) {
                statement.close();
                throw e;
            }
        };
    }

    public ResourceIterable<Relationship> getRelationships(RelationshipType ... types2) {
        return this.getRelationships(Direction.BOTH, types2);
    }

    public ResourceIterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        return this.getRelationships(dir, new RelationshipType[]{type});
    }

    public ResourceIterable<Relationship> getRelationships(final Direction direction, RelationshipType ... types2) {
        int[] typeIds;
        try (Statement statement = this.actions.statement();){
            typeIds = this.relTypeIds(types2, statement);
        }
        return new ResourceIterable<Relationship>(){

            @Override
            public ResourceIterator<Relationship> iterator() {
                Statement statement = NodeProxy.this.actions.statement();
                try {
                    RelationshipConversion result2 = new RelationshipConversion(NodeProxy.this.actions);
                    result2.iterator = statement.readOperations().nodeGetRelationships(NodeProxy.this.nodeId, direction, typeIds);
                    result2.statement = statement;
                    return result2;
                }
                catch (EntityNotFoundException e) {
                    statement.close();
                    throw new NotFoundException(String.format("Node %d not found", NodeProxy.this.nodeId), e);
                }
                catch (Throwable e) {
                    statement.close();
                    throw e;
                }
            }
        };
    }

    @Override
    public boolean hasRelationship() {
        return this.hasRelationship(Direction.BOTH);
    }

    @Override
    public boolean hasRelationship(Direction dir) {
        try (Iterator rels = this.getRelationships(dir).iterator();){
            boolean bl = rels.hasNext();
            return bl;
        }
    }

    @Override
    public boolean hasRelationship(RelationshipType ... types2) {
        return this.hasRelationship(Direction.BOTH, types2);
    }

    @Override
    public boolean hasRelationship(Direction direction, RelationshipType ... types2) {
        try (Iterator rels = this.getRelationships(direction, types2).iterator();){
            boolean bl = rels.hasNext();
            return bl;
        }
    }

    @Override
    public boolean hasRelationship(RelationshipType type, Direction dir) {
        return this.hasRelationship(dir, type);
    }

    @Override
    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        try (Iterator rels = this.getRelationships(dir, new RelationshipType[]{type}).iterator();){
            if (!rels.hasNext()) {
                Relationship relationship = null;
                return relationship;
            }
            Relationship rel = (Relationship)rels.next();
            while (rels.hasNext()) {
                Relationship other2 = (Relationship)rels.next();
                if (other2.equals(rel)) continue;
                throw new NotFoundException("More than one relationship[" + type + ", " + (Object)((Object)dir) + "] found for " + this);
            }
            Relationship relationship = rel;
            return relationship;
        }
    }

    private void assertInUnterminatedTransaction() {
        this.actions.assertInUnterminatedTransaction();
    }

    @Override
    public void setProperty(String key, Object value) {
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            try {
                statement.dataWriteOperations().nodeSetProperty(this.nodeId, Property.property(propertyKeyId, value));
            }
            catch (ConstraintValidationKernelException e) {
                throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e);
            }
            catch (IllegalArgumentException e) {
                this.actions.failTransaction();
                throw e;
            }
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while setting property: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object removeProperty(String key) throws NotFoundException {
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            Object object = statement.dataWriteOperations().nodeRemoveProperty(this.nodeId, propertyKeyId).value(null);
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while removing property: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(key);
            Object value = statement.readOperations().nodeGetProperty(this.nodeId, propertyKeyId);
            Object object = value == null ? defaultValue : value;
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<String> getPropertyKeys() {
        try (Statement statement = this.actions.statement();){
            ArrayList<String> keys2 = new ArrayList<String>();
            PrimitiveIntIterator properties = statement.readOperations().nodeGetPropertyKeys(this.getId());
            while (properties.hasNext()) {
                keys2.add(statement.readOperations().propertyKeyGetName(properties.next()));
            }
            ArrayList<String> arrayList = keys2;
            return arrayList;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found", e);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, Object> getProperties(String ... keys) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, Object> getAllProperties() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Object getProperty(String key) throws NotFoundException {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        Throwable throwable = null;
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(key);
            if (propertyKeyId == -1) {
                throw new NotFoundException(String.format("No such property, '%s'.", key));
            }
            Object value = statement.readOperations().nodeGetProperty(this.nodeId, propertyKeyId);
            if (value == null) {
                throw new PropertyNotFoundException(propertyKeyId, EntityType.NODE, this.nodeId);
            }
            Object object = value;
            return object;
        }
        catch (EntityNotFoundException | PropertyNotFoundException e) {
            try {
                throw new NotFoundException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(key);
            boolean bl = statement.readOperations().nodeHasProperty(this.nodeId, propertyKeyId);
            return bl;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    public int compareTo(Object node) {
        long theirId;
        Node n = (Node)node;
        long ourId = this.getId();
        if (ourId < (theirId = n.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof Node && this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return (int)(this.nodeId >>> 32 ^ this.nodeId);
    }

    public String toString() {
        return "Node[" + this.getId() + "]";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        if (otherNode == null) {
            throw new IllegalArgumentException("Other node is null.");
        }
        try (Statement statement = this.actions.statement();){
            int relationshipTypeId = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName(type.name());
            long relationshipId = statement.dataWriteOperations().relationshipCreate(relationshipTypeId, this.nodeId, otherNode.getId());
            Relationship relationship = this.actions.newRelationshipProxy(relationshipId, this.nodeId, relationshipTypeId, otherNode.getId());
            return relationship;
        }
        catch (RelationshipTypeIdNotFoundKernelException | IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node[" + e.entityId() + "] is deleted and cannot be used to create a relationship");
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    @Override
    public void addLabel(Label label) {
        try (Statement statement = this.actions.statement();){
            try {
                statement.dataWriteOperations().nodeAddLabel(this.getId(), statement.tokenWriteOperations().labelGetOrCreateForName(label.name()));
            }
            catch (ConstraintValidationKernelException e) {
                throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e);
            }
        }
        catch (IllegalTokenNameException e) {
            throw new ConstraintViolationException(String.format("Invalid label name '%s'.", label.name()), e);
        }
        catch (TooManyLabelsException e) {
            throw new ConstraintViolationException("Unable to add label.", e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    @Override
    public void removeLabel(Label label) {
        try (Statement statement = this.actions.statement();){
            int labelId = statement.readOperations().labelGetForName(label.name());
            if (labelId != -1) {
                statement.dataWriteOperations().nodeRemoveLabel(this.getId(), labelId);
            }
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasLabel(Label label) {
        try (Statement statement = this.actions.statement();){
            int labelId = statement.readOperations().labelGetForName(label.name());
            boolean bl = statement.readOperations().nodeHasLabel(this.getId(), labelId);
            return bl;
        }
        catch (EntityNotFoundException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<Label> getLabels() {
        try (Statement statement = this.actions.statement();){
            PrimitiveIntIterator labels2 = statement.readOperations().nodeGetLabels(this.getId());
            ArrayList<Label> keys2 = new ArrayList<Label>();
            while (labels2.hasNext()) {
                int labelId = labels2.next();
                keys2.add(Label.label(statement.readOperations().labelGetName(labelId)));
            }
            ArrayList<Label> arrayList = keys2;
            return arrayList;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found", e);
        }
        catch (LabelNotFoundKernelException e) {
            throw new IllegalStateException("Label retrieved through kernel API should exist.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDegree() {
        try (Statement statement = this.actions.statement();){
            int n = statement.readOperations().nodeGetDegree(this.nodeId, Direction.BOTH);
            return n;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDegree(RelationshipType type) {
        try (Statement statement = this.actions.statement();){
            ReadOperations ops = statement.readOperations();
            int typeId = ops.relationshipTypeGetForName(type.name());
            if (typeId == -1) {
                int n = 0;
                return n;
            }
            int n = ops.nodeGetDegree(this.nodeId, Direction.BOTH, typeId);
            return n;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDegree(Direction direction) {
        try (Statement statement = this.actions.statement();){
            ReadOperations ops = statement.readOperations();
            int n = ops.nodeGetDegree(this.nodeId, direction);
            return n;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDegree(RelationshipType type, Direction direction) {
        try (Statement statement = this.actions.statement();){
            ReadOperations ops = statement.readOperations();
            int typeId = ops.relationshipTypeGetForName(type.name());
            if (typeId == -1) {
                int n = 0;
                return n;
            }
            int n = ops.nodeGetDegree(this.nodeId, direction, typeId);
            return n;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        try (Statement statement = this.actions.statement();){
            ReadOperations ops = statement.readOperations();
            Iterable<RelationshipType> iterable = this.map2relTypes(statement, ops.nodeGetRelationshipTypes(this.nodeId));
            return iterable;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found.", e);
        }
    }

    private int[] relTypeIds(RelationshipType[] types2, Statement statement) {
        int[] ids2 = new int[types2.length];
        int outIndex = 0;
        for (int i = 0; i < types2.length; ++i) {
            int id = statement.readOperations().relationshipTypeGetForName(types2[i].name());
            if (id == -1) continue;
            ids2[outIndex++] = id;
        }
        if (outIndex != ids2.length) {
            ids2 = Arrays.copyOf(ids2, outIndex);
        }
        return ids2;
    }

    private Iterable<RelationshipType> map2relTypes(Statement statement, PrimitiveIntIterator input2) {
        return Iterators.asList(PrimitiveIntCollections.map(id -> {
            try {
                return RelationshipType.withName(statement.readOperations().relationshipTypeGetName(id));
            }
            catch (RelationshipTypeIdNotFoundKernelException e) {
                throw new IllegalStateException("Kernel API returned non-existent relationship type: " + id);
            }
        }, input2));
    }

    public static interface NodeActions {
        public Statement statement();

        public GraphDatabaseService getGraphDatabase();

        public void assertInUnterminatedTransaction();

        public void failTransaction();

        public Relationship newRelationshipProxy(long var1, long var3, int var5, long var6);
    }
}

