/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.api.state.TxState;

abstract class StateDefaults<KEY, RO, RW extends RO> {
    StateDefaults() {
    }

    final RO get(TxState state, KEY key) {
        Map<KEY, RW> map2 = this.getMap(state);
        if (map2 == null) {
            return this.defaultValue();
        }
        RW value = map2.get(key);
        return (RO)(value == null ? this.defaultValue() : value);
    }

    final RW getOrCreate(TxState state, KEY key) {
        RW value;
        Map<KEY, RW> map2 = this.getMap(state);
        if (map2 == null) {
            map2 = new HashMap<KEY, RW>();
            this.setMap(state, map2);
        }
        if ((value = map2.get(key)) == null) {
            value = this.createValue(key, state);
            map2.put(key, value);
        }
        return value;
    }

    final Iterable<RO> values(TxState state) {
        Map<KEY, RW> map2 = this.getMap(state);
        if (map2 == null) {
            return Iterables.empty();
        }
        Collection<RW> values2 = map2.values();
        return values2;
    }

    abstract Map<KEY, RW> getMap(TxState var1);

    abstract void setMap(TxState var1, Map<KEY, RW> var2);

    abstract RW createValue(KEY var1, TxState var2);

    abstract RO defaultValue();
}

