/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Iterator;
import java.util.function.Predicate;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.CombiningIterator;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.util.VersionedHashMap;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.PropertyContainerState;

public class PropertyContainerStateImpl
implements PropertyContainerState {
    private final long id;
    private static final ResourceIterator<StorageProperty> NO_PROPERTIES = Iterators.emptyIterator();
    private VersionedHashMap<Integer, StorageProperty> addedProperties;
    private VersionedHashMap<Integer, StorageProperty> changedProperties;
    private VersionedHashMap<Integer, StorageProperty> removedProperties;
    private final Predicate<StorageProperty> excludePropertiesWeKnowAbout = new Predicate<StorageProperty>(){

        @Override
        public boolean test(StorageProperty item) {
            return !(PropertyContainerStateImpl.this.removedProperties != null && PropertyContainerStateImpl.this.removedProperties.containsKey(item.propertyKeyId()) || PropertyContainerStateImpl.this.addedProperties != null && PropertyContainerStateImpl.this.addedProperties.containsKey(item.propertyKeyId()) || PropertyContainerStateImpl.this.changedProperties != null && PropertyContainerStateImpl.this.changedProperties.containsKey(item.propertyKeyId()));
        }
    };

    PropertyContainerStateImpl(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void clear() {
        if (this.changedProperties != null) {
            this.changedProperties.clear();
        }
        if (this.addedProperties != null) {
            this.addedProperties.clear();
        }
        if (this.removedProperties != null) {
            this.removedProperties.clear();
        }
    }

    public void changeProperty(DefinedProperty property) {
        if (this.addedProperties != null && this.addedProperties.containsKey(property.propertyKeyId())) {
            this.addedProperties.put(property.propertyKeyId(), property);
            return;
        }
        if (this.changedProperties == null) {
            this.changedProperties = new VersionedHashMap();
        }
        this.changedProperties.put(property.propertyKeyId(), property);
        if (this.removedProperties != null) {
            this.removedProperties.remove(property.propertyKeyId());
        }
    }

    public void addProperty(DefinedProperty property) {
        StorageProperty removed;
        if (this.removedProperties != null && (removed = this.removedProperties.remove(property.propertyKeyId())) != null) {
            this.changeProperty(property);
            return;
        }
        if (this.addedProperties == null) {
            this.addedProperties = new VersionedHashMap();
        }
        this.addedProperties.put(property.propertyKeyId(), property);
    }

    public void removeProperty(DefinedProperty property) {
        if (this.addedProperties != null && this.addedProperties.remove(property.propertyKeyId()) != null) {
            return;
        }
        if (this.removedProperties == null) {
            this.removedProperties = new VersionedHashMap();
        }
        this.removedProperties.put(property.propertyKeyId(), property);
        if (this.changedProperties != null) {
            this.changedProperties.remove(property.propertyKeyId());
        }
    }

    @Override
    public Iterator<StorageProperty> addedProperties() {
        return this.addedProperties != null ? this.addedProperties.values().iterator() : NO_PROPERTIES;
    }

    @Override
    public Iterator<StorageProperty> changedProperties() {
        return this.changedProperties != null ? this.changedProperties.values().iterator() : NO_PROPERTIES;
    }

    @Override
    public Iterator<Integer> removedProperties() {
        return this.removedProperties != null ? this.removedProperties.keySet().iterator() : Iterators.emptyIterator();
    }

    @Override
    public Iterator<StorageProperty> addedAndChangedProperties() {
        Iterator<StorageProperty> out = null;
        if (this.addedProperties != null) {
            out = this.addedProperties.values().iterator();
        }
        if (this.changedProperties != null) {
            out = out != null ? new CombiningIterator<StorageProperty>(Iterators.iterator(out, this.changedProperties.values().iterator())) : this.changedProperties.values().iterator();
        }
        return out != null ? out : NO_PROPERTIES;
    }

    @Override
    public Iterator<StorageProperty> augmentProperties(Iterator<StorageProperty> iterator2) {
        if (this.removedProperties != null || this.addedProperties != null || this.changedProperties != null) {
            iterator2 = new FilteringIterator<StorageProperty>(iterator2, this.excludePropertiesWeKnowAbout);
            if (this.addedProperties != null && !this.addedProperties.isEmpty()) {
                iterator2 = new CombiningIterator<StorageProperty>(Iterators.iterator(iterator2, this.addedProperties.values().iterator()));
            }
            if (this.changedProperties != null && !this.changedProperties.isEmpty()) {
                iterator2 = new CombiningIterator<StorageProperty>(Iterators.iterator(iterator2, this.changedProperties.values().iterator()));
            }
        }
        return iterator2;
    }

    @Override
    public void accept(PropertyContainerState.Visitor visitor) throws ConstraintValidationKernelException {
        if (this.addedProperties != null || this.removedProperties != null || this.changedProperties != null) {
            visitor.visitPropertyChanges(this.id, this.addedProperties(), this.changedProperties(), this.removedProperties());
        }
    }

    @Override
    public boolean hasChanges() {
        return this.addedProperties != null || this.removedProperties != null || this.changedProperties != null;
    }

    @Override
    public StorageProperty getChangedProperty(int propertyKeyId) {
        return this.changedProperties != null ? this.changedProperties.get(propertyKeyId) : null;
    }

    @Override
    public StorageProperty getAddedProperty(int propertyKeyId) {
        return this.addedProperties != null ? this.addedProperties.get(propertyKeyId) : null;
    }

    @Override
    public boolean isPropertyRemoved(int propertyKeyId) {
        return this.removedProperties != null && this.removedProperties.containsKey(propertyKeyId);
    }
}

