/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.legacyindex;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.legacyindex.AutoIndexingKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.LegacyIndexNotFoundKernelException;
import org.neo4j.kernel.api.legacyindex.AutoIndexOperations;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.storageengine.api.Token;

public class InternalAutoIndexOperations
implements AutoIndexOperations {
    private AtomicReference<Set<String>> propertyKeysToInclude = new AtomicReference(Collections.emptySet());
    private final PropertyKeyTokenHolder propertyKeyLookup;
    private final EntityType type;
    private volatile boolean enabled;
    private volatile boolean indexCreated;

    public InternalAutoIndexOperations(PropertyKeyTokenHolder propertyKeyLookup, EntityType type) {
        this.propertyKeyLookup = propertyKeyLookup;
        this.type = type;
    }

    @Override
    public void propertyAdded(DataWriteOperations ops, long entityId, Property property) throws AutoIndexingKernelException {
        if (this.enabled) {
            try {
                String name2 = ((Token)this.propertyKeyLookup.getTokenById(property.propertyKeyId())).name();
                if (this.propertyKeysToInclude.get().contains(name2)) {
                    this.ensureIndexExists(ops);
                    this.type.add(ops, entityId, name2, property.value());
                }
            }
            catch (EntityNotFoundException | PropertyNotFoundException | LegacyIndexNotFoundKernelException e) {
                throw new AutoIndexingKernelException(e);
            }
            catch (TokenNotFoundException e) {
                throw new AutoIndexingKernelException(new PropertyKeyIdNotFoundKernelException(property.propertyKeyId(), e));
            }
        }
    }

    @Override
    public void propertyChanged(DataWriteOperations ops, long entityId, Property oldProperty, Property newProperty) throws AutoIndexingKernelException {
        if (this.enabled) {
            try {
                String name2 = ((Token)this.propertyKeyLookup.getTokenById(oldProperty.propertyKeyId())).name();
                if (this.propertyKeysToInclude.get().contains(name2)) {
                    this.ensureIndexExists(ops);
                    this.type.remove(ops, entityId, name2, oldProperty.value());
                    this.type.add(ops, entityId, name2, newProperty.value());
                }
            }
            catch (EntityNotFoundException | PropertyNotFoundException | LegacyIndexNotFoundKernelException e) {
                throw new AutoIndexingKernelException(e);
            }
            catch (TokenNotFoundException e) {
                throw new AutoIndexingKernelException(new PropertyKeyIdNotFoundKernelException(oldProperty.propertyKeyId(), e));
            }
        }
    }

    @Override
    public void propertyRemoved(DataWriteOperations ops, long entityId, int propertyKey) throws AutoIndexingKernelException {
        if (this.enabled) {
            try {
                String name2 = ((Token)this.propertyKeyLookup.getTokenById(propertyKey)).name();
                if (this.propertyKeysToInclude.get().contains(name2)) {
                    this.ensureIndexExists(ops);
                    this.type.remove(ops, entityId);
                }
            }
            catch (EntityNotFoundException | LegacyIndexNotFoundKernelException e) {
                throw new AutoIndexingKernelException(e);
            }
            catch (TokenNotFoundException e) {
                throw new AutoIndexingKernelException(new PropertyKeyIdNotFoundKernelException(propertyKey, e));
            }
        }
    }

    @Override
    public void entityRemoved(DataWriteOperations ops, long entityId) throws AutoIndexingKernelException {
        if (this.enabled) {
            try {
                this.ensureIndexExists(ops);
                this.type.remove(ops, entityId);
            }
            catch (EntityNotFoundException | LegacyIndexNotFoundKernelException e) {
                throw new AutoIndexingKernelException(e);
            }
        }
    }

    void replacePropertyKeysToInclude(List<String> propertyKeysToIncludeNow) {
        HashSet<String> copiedPropertyKeysToIncludeNow = new HashSet<String>(propertyKeysToIncludeNow.size());
        copiedPropertyKeysToIncludeNow.addAll(propertyKeysToIncludeNow);
        this.propertyKeysToInclude.set(copiedPropertyKeysToIncludeNow);
    }

    @Override
    public void enabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void startAutoIndexingProperty(String propName) {
        this.propertyKeysToInclude.getAndUpdate(current -> {
            HashSet<String> updated2 = new HashSet<String>();
            updated2.addAll((Collection<String>)current);
            updated2.add(propName);
            return updated2;
        });
    }

    @Override
    public void stopAutoIndexingProperty(String propName) {
        this.propertyKeysToInclude.getAndUpdate(current -> {
            HashSet updated2 = new HashSet();
            updated2.addAll(current);
            updated2.remove(propName);
            return updated2;
        });
    }

    @Override
    public Set<String> getAutoIndexedProperties() {
        return Collections.unmodifiableSet(this.propertyKeysToInclude.get());
    }

    private void ensureIndexExists(DataWriteOperations ops) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
        if (!this.indexCreated) {
            this.type.ensureIndexExists(ops);
            this.indexCreated = true;
        }
    }

    public static enum EntityType {
        NODE{

            @Override
            public void add(DataWriteOperations ops, long entityId, String keyName, Object value) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
                ops.nodeAddToLegacyIndex("node_auto_index", entityId, keyName, value);
            }

            @Override
            public void remove(DataWriteOperations ops, long entityId, String keyName, Object value) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
                ops.nodeRemoveFromLegacyIndex("node_auto_index", entityId, keyName, value);
            }

            @Override
            public void remove(DataWriteOperations ops, long entityId, String keyName) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
                ops.nodeRemoveFromLegacyIndex("node_auto_index", entityId, keyName);
            }

            @Override
            public void remove(DataWriteOperations ops, long entityId) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
                ops.nodeRemoveFromLegacyIndex("node_auto_index", entityId);
            }

            @Override
            public void ensureIndexExists(DataWriteOperations ops) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
                ops.nodeLegacyIndexCreateLazily("node_auto_index", null);
            }
        }
        ,
        RELATIONSHIP{

            @Override
            public void add(DataWriteOperations ops, long entityId, String keyName, Object value) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
                ops.relationshipAddToLegacyIndex("relationship_auto_index", entityId, keyName, value);
            }

            @Override
            public void remove(DataWriteOperations ops, long entityId, String keyName, Object value) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
                ops.relationshipRemoveFromLegacyIndex("relationship_auto_index", entityId, keyName, value);
            }

            @Override
            public void remove(DataWriteOperations ops, long entityId, String keyName) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
                ops.relationshipRemoveFromLegacyIndex("relationship_auto_index", entityId, keyName);
            }

            @Override
            public void remove(DataWriteOperations ops, long entityId) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
                ops.relationshipRemoveFromLegacyIndex("relationship_auto_index", entityId);
            }

            @Override
            public void ensureIndexExists(DataWriteOperations ops) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
                ops.relationshipLegacyIndexCreateLazily("relationship_auto_index", null);
            }
        };


        public abstract void add(DataWriteOperations var1, long var2, String var4, Object var5) throws LegacyIndexNotFoundKernelException, EntityNotFoundException;

        public abstract void remove(DataWriteOperations var1, long var2, String var4, Object var5) throws LegacyIndexNotFoundKernelException, EntityNotFoundException;

        public abstract void remove(DataWriteOperations var1, long var2, String var4) throws LegacyIndexNotFoundKernelException, EntityNotFoundException;

        public abstract void remove(DataWriteOperations var1, long var2) throws LegacyIndexNotFoundKernelException, EntityNotFoundException;

        public abstract void ensureIndexExists(DataWriteOperations var1) throws LegacyIndexNotFoundKernelException, EntityNotFoundException;
    }
}

