/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.storageengine.api.CommandsToApply;

public class NodePropertyCommandsExtractor
extends TransactionApplier.Adapter
implements BatchTransactionApplier {
    private final PrimitiveLongObjectMap<Command.NodeCommand> nodeCommandsById = Primitive.longObjectMap();
    private final PrimitiveLongObjectMap<List<Command.PropertyCommand>> propertyCommandsByNodeIds = Primitive.longObjectMap();
    private boolean hasUpdates;

    @Override
    public TransactionApplier startTx(CommandsToApply transaction) {
        return this;
    }

    @Override
    public TransactionApplier startTx(CommandsToApply transaction, LockGroup lockGroup) {
        return this.startTx(transaction);
    }

    @Override
    public void close() throws Exception {
        this.nodeCommandsById.clear();
        this.propertyCommandsByNodeIds.clear();
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        this.nodeCommandsById.put(command.getKey(), command);
        if (!this.hasUpdates && this.hasLabelChanges(command)) {
            this.hasUpdates = true;
        }
        return false;
    }

    private boolean hasLabelChanges(Command.NodeCommand command) {
        long after;
        long before = ((NodeRecord)command.getBefore()).getLabelField();
        return before != (after = ((NodeRecord)command.getAfter()).getLabelField()) || NodeLabelsField.fieldPointsToDynamicRecordOfLabels(before) || NodeLabelsField.fieldPointsToDynamicRecordOfLabels(after);
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
        PropertyRecord record = (PropertyRecord)command.getAfter();
        if (record.isNodeSet()) {
            long nodeId = ((PropertyRecord)command.getAfter()).getNodeId();
            List<Command.PropertyCommand> group2 = this.propertyCommandsByNodeIds.get(nodeId);
            if (group2 == null) {
                group2 = new ArrayList<Command.PropertyCommand>();
                this.propertyCommandsByNodeIds.put(nodeId, group2);
            }
            group2.add(command);
            this.hasUpdates = true;
        }
        return false;
    }

    public boolean containsAnyNodeOrPropertyUpdate() {
        return this.hasUpdates;
    }

    public PrimitiveLongObjectMap<Command.NodeCommand> nodeCommandsById() {
        return this.nodeCommandsById;
    }

    public PrimitiveLongObjectMap<List<Command.PropertyCommand>> propertyCommandsByNodeIds() {
        return this.propertyCommandsByNodeIds;
    }
}

