/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.IntPredicate;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.exceptions.index.FlipFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexCountsRemover;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.NodePropertyUpdates;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.schema.IndexSample;

public class MultipleIndexPopulator
implements IndexPopulator {
    protected final Queue<NodePropertyUpdate> queue = new LinkedBlockingQueue<NodePropertyUpdate>();
    private final List<IndexPopulation> populations = new CopyOnWriteArrayList<IndexPopulation>();
    private final IndexStoreView storeView;
    private final LogProvider logProvider;
    protected final Log log;

    public MultipleIndexPopulator(IndexStoreView storeView, LogProvider logProvider) {
        this.storeView = storeView;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(IndexPopulationJob.class);
    }

    public IndexPopulation addPopulator(IndexPopulator populator, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, IndexConfiguration config, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory, String indexUserDescription) {
        IndexPopulation population = this.createPopulation(populator, descriptor, config, providerDescriptor, flipper, failedIndexProxyFactory, indexUserDescription);
        this.populations.add(population);
        return population;
    }

    protected IndexPopulation createPopulation(IndexPopulator populator, IndexDescriptor descriptor, IndexConfiguration config, SchemaIndexProvider.Descriptor providerDescriptor, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory, String indexUserDescription) {
        return new IndexPopulation(populator, descriptor, config, providerDescriptor, flipper, failedIndexProxyFactory, indexUserDescription);
    }

    public boolean hasPopulators() {
        return !this.populations.isEmpty();
    }

    @Override
    public void create() {
        this.forEachPopulation(population -> {
            this.log.info("Index population started: [%s]", population.indexUserDescription);
            population.populator.create();
        });
    }

    @Override
    public void drop() throws IOException {
        throw new UnsupportedOperationException("Can't drop indexes from this populator implementation");
    }

    @Override
    public void add(Collection<NodePropertyUpdate> updates) {
        throw new UnsupportedOperationException("Can't populate directly using this populator implementation. ");
    }

    public StoreScan<IndexPopulationFailedKernelException> indexAllNodes() {
        int[] labelIds = this.labelIds();
        int[] propertyKeyIds2 = this.propertyKeyIds();
        IntPredicate labelIdFilter = labelId -> PrimitiveIntCollections.contains(labelIds, labelId);
        IntPredicate propertyKeyIdFilter = propertyKeyId -> PrimitiveIntCollections.contains(propertyKeyIds2, propertyKeyId);
        return this.storeView.visitNodes(labelIdFilter, propertyKeyIdFilter, new NodePopulationVisitor(), null);
    }

    public void queue(NodePropertyUpdate update2) {
        this.queue.add(update2);
    }

    public void fail(Throwable failure) {
        for (IndexPopulation population : this.populations) {
            this.fail(population, failure);
        }
    }

    protected void fail(IndexPopulation population, Throwable failure) {
        Throwable cause;
        boolean removed = this.populations.remove(population);
        if (!removed) {
            return;
        }
        if (failure instanceof IndexPopulationFailedKernelException && (cause = failure.getCause()) instanceof IndexEntryConflictException) {
            failure = cause;
        }
        if (!(failure instanceof IndexEntryConflictException)) {
            this.log.error(String.format("Failed to populate index: [%s]", population.indexUserDescription), failure);
        }
        population.flipToFailed(failure);
        try {
            population.populator.markAsFailed(IndexPopulationFailure.failure(failure).asString());
            population.populator.close(false);
        }
        catch (Throwable e) {
            this.log.error(String.format("Unable to close failed populator for index: [%s]", population.indexUserDescription), e);
        }
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    public void verifyAllDeferredConstraints(PropertyAccessor accessor) {
        this.forEachPopulation(population -> population.populator.verifyDeferredConstraints(accessor));
    }

    @Override
    public MultipleIndexUpdater newPopulatingUpdater(PropertyAccessor accessor) {
        HashMap<IndexPopulation, IndexUpdater> populationsWithUpdaters = new HashMap<IndexPopulation, IndexUpdater>();
        this.forEachPopulation(population -> {
            IndexUpdater updater = population.populator.newPopulatingUpdater(accessor);
            populationsWithUpdaters.put((IndexPopulation)population, updater);
        });
        return new MultipleIndexUpdater(this, populationsWithUpdaters, this.logProvider);
    }

    @Override
    public void close(boolean populationCompletedSuccessfully) {
        this.forEachPopulation(population -> population.populator.close(populationCompletedSuccessfully));
    }

    @Override
    public void markAsFailed(String failure) throws IOException {
        throw new UnsupportedOperationException("Multiple index populator can't be marked as failed.");
    }

    @Override
    public void includeSample(NodePropertyUpdate update2) {
        throw new UnsupportedOperationException("Multiple index populator can't perform index sampling.");
    }

    @Override
    public IndexSample sampleResult() {
        throw new UnsupportedOperationException("Multiple index populator can't perform index sampling.");
    }

    public void replaceIndexCounts(long uniqueElements, long maxUniqueElements, long indexSize) {
        this.forEachPopulation(population -> this.storeView.replaceIndexCounts(population.descriptor, uniqueElements, maxUniqueElements, indexSize));
    }

    public void flipAfterPopulation() {
        for (IndexPopulation population : this.populations) {
            try {
                population.flip();
                this.populations.remove(population);
            }
            catch (Throwable t) {
                this.fail(population, t);
            }
        }
    }

    private int[] propertyKeyIds() {
        return this.populations.stream().mapToInt(population -> population.descriptor.getPropertyKeyId()).toArray();
    }

    private int[] labelIds() {
        return this.populations.stream().mapToInt(population -> population.descriptor.getLabelId()).toArray();
    }

    public void cancel() {
        this.replaceIndexCounts(0L, 0L, 0L);
        this.close(false);
    }

    protected void populateFromQueue(long currentlyIndexedNodeId) {
        this.populateFromQueueIfAvailable(currentlyIndexedNodeId);
    }

    private void populateFromQueueIfAvailable(long currentlyIndexedNodeId) {
        if (!this.queue.isEmpty()) {
            try (MultipleIndexUpdater updater = this.newPopulatingUpdater(this.storeView);){
                do {
                    NodePropertyUpdate update2;
                    if ((update2 = this.queue.poll()).getNodeId() > currentlyIndexedNodeId) continue;
                    updater.process(update2);
                } while (!this.queue.isEmpty());
            }
        }
    }

    private void forEachPopulation(ThrowingConsumer<IndexPopulation, Exception> action) {
        for (IndexPopulation population : this.populations) {
            try {
                action.accept(population);
            }
            catch (Throwable failure) {
                this.fail(population, failure);
            }
        }
    }

    private class NodePopulationVisitor
    implements Visitor<NodePropertyUpdates, IndexPopulationFailedKernelException> {
        private NodePopulationVisitor() {
        }

        @Override
        public boolean visit(NodePropertyUpdates updates) throws IndexPopulationFailedKernelException {
            this.add(updates);
            MultipleIndexPopulator.this.populateFromQueue(updates.getNodeId());
            return false;
        }

        private void add(NodePropertyUpdates updates) {
            MultipleIndexPopulator.this.forEachPopulation(population -> ((IndexPopulation)population).addAll(updates.getPropertyUpdates()));
        }
    }

    protected class IndexPopulation {
        final IndexPopulator populator;
        final IndexDescriptor descriptor;
        final IndexConfiguration config;
        final SchemaIndexProvider.Descriptor providerDescriptor;
        final IndexCountsRemover indexCountsRemover;
        final FlippableIndexProxy flipper;
        final FailedIndexProxyFactory failedIndexProxyFactory;
        final String indexUserDescription;
        private Collection<NodePropertyUpdate> applicableUpdates = new ArrayList<NodePropertyUpdate>();

        IndexPopulation(IndexPopulator populator, IndexDescriptor descriptor, IndexConfiguration config, SchemaIndexProvider.Descriptor providerDescriptor, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory, String indexUserDescription) {
            this.populator = populator;
            this.descriptor = descriptor;
            this.config = config;
            this.providerDescriptor = providerDescriptor;
            this.flipper = flipper;
            this.failedIndexProxyFactory = failedIndexProxyFactory;
            this.indexUserDescription = indexUserDescription;
            this.indexCountsRemover = new IndexCountsRemover(MultipleIndexPopulator.this.storeView, descriptor);
        }

        private void flipToFailed(Throwable t) {
            this.flipper.flipTo(new FailedIndexProxy(this.descriptor, this.config, this.providerDescriptor, this.indexUserDescription, this.populator, IndexPopulationFailure.failure(t), this.indexCountsRemover, MultipleIndexPopulator.this.logProvider));
        }

        private void addAll(Collection<NodePropertyUpdate> updates) throws IndexEntryConflictException, IOException {
            for (NodePropertyUpdate update2 : updates) {
                if (!this.isApplicable(update2)) continue;
                this.populator.includeSample(update2);
                this.applicableUpdates.add(update2);
            }
            if (!this.applicableUpdates.isEmpty()) {
                this.addApplicable(this.applicableUpdates);
                this.applicableUpdates.clear();
            }
        }

        void addApplicable(Collection<NodePropertyUpdate> updates) throws IOException, IndexEntryConflictException {
            this.populator.add(updates);
        }

        private boolean isApplicable(NodePropertyUpdate update2) {
            return update2.forLabel(this.descriptor.getLabelId()) && update2.getPropertyKeyId() == this.descriptor.getPropertyKeyId();
        }

        private void flip() throws FlipFailedKernelException {
            this.flipper.flip(() -> {
                MultipleIndexPopulator.this.populateFromQueueIfAvailable(Long.MAX_VALUE);
                IndexSample sample = this.populator.sampleResult();
                MultipleIndexPopulator.this.storeView.replaceIndexCounts(this.descriptor, sample.uniqueValues(), sample.sampleSize(), sample.indexSize());
                this.populator.close(true);
                return null;
            }, this.failedIndexProxyFactory);
            MultipleIndexPopulator.this.log.info("Index population completed. Index is now online: [%s]", this.indexUserDescription);
        }
    }

    private static class MultipleIndexUpdater
    implements IndexUpdater {
        private final Map<IndexPopulation, IndexUpdater> populationsWithUpdaters;
        private final MultipleIndexPopulator multipleIndexPopulator;
        private final Log log;

        MultipleIndexUpdater(MultipleIndexPopulator multipleIndexPopulator, Map<IndexPopulation, IndexUpdater> populationsWithUpdaters, LogProvider logProvider) {
            this.multipleIndexPopulator = multipleIndexPopulator;
            this.populationsWithUpdaters = populationsWithUpdaters;
            this.log = logProvider.getLog(this.getClass());
        }

        @Override
        public void remove(PrimitiveLongSet nodeIds) {
            throw new UnsupportedOperationException("Index populators don't do removal");
        }

        @Override
        public void process(NodePropertyUpdate update2) {
            Iterator<Map.Entry<IndexPopulation, IndexUpdater>> iterator2 = this.populationsWithUpdaters.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<IndexPopulation, IndexUpdater> entry = iterator2.next();
                IndexPopulation population = entry.getKey();
                IndexUpdater updater = entry.getValue();
                if (!population.isApplicable(update2)) continue;
                try {
                    updater.process(update2);
                }
                catch (Throwable t) {
                    try {
                        updater.close();
                    }
                    catch (Throwable ce) {
                        this.log.error(String.format("Failed to close index updater: [%s]", updater), ce);
                    }
                    iterator2.remove();
                    this.multipleIndexPopulator.fail(population, t);
                }
            }
        }

        @Override
        public void close() {
            Iterator<Map.Entry<IndexPopulation, IndexUpdater>> iterator2 = this.populationsWithUpdaters.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<IndexPopulation, IndexUpdater> entry = iterator2.next();
                IndexPopulation population = entry.getKey();
                IndexUpdater updater = entry.getValue();
                try {
                    updater.close();
                }
                catch (Throwable t) {
                    iterator2.remove();
                    this.multipleIndexPopulator.fail(population, t);
                }
            }
        }
    }
}

