/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import java.util.Iterator;
import java.util.function.Consumer;
import org.neo4j.cursor.Cursor;
import org.neo4j.storageengine.api.LabelItem;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;

public class TxLabelCursor
implements Cursor<LabelItem>,
LabelItem {
    private final Consumer<TxLabelCursor> instanceCache;
    protected Cursor<LabelItem> cursor;
    protected ReadableDiffSets<Integer> labelDiffSet;
    protected int label;
    private Iterator<Integer> added;

    public TxLabelCursor(Consumer<TxLabelCursor> instanceCache) {
        this.instanceCache = instanceCache;
    }

    public TxLabelCursor init(Cursor<LabelItem> cursor, ReadableDiffSets<Integer> labelDiffSet) {
        this.cursor = cursor;
        this.labelDiffSet = labelDiffSet;
        this.added = null;
        return this;
    }

    @Override
    public boolean next() {
        if (this.added == null) {
            while (this.cursor != null && this.cursor.next()) {
                this.label = ((LabelItem)this.cursor.get()).getAsInt();
                if (this.labelDiffSet.isRemoved(this.label)) continue;
                return true;
            }
            this.added = this.labelDiffSet.getAdded().iterator();
        }
        if (this.added.hasNext()) {
            this.label = this.added.next();
            return true;
        }
        this.label = -1;
        return false;
    }

    @Override
    public LabelItem get() {
        if (this.label == -1) {
            throw new IllegalStateException();
        }
        return this;
    }

    @Override
    public int getAsInt() {
        return this.label;
    }

    @Override
    public void close() {
        this.cursor.close();
        this.cursor = null;
        this.instanceCache.accept(this);
    }
}

