/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import java.util.Iterator;
import java.util.function.Consumer;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.cursor.TxAbstractNodeCursor;
import org.neo4j.storageengine.api.NodeItem;

public class TxIteratorNodeCursor
extends TxAbstractNodeCursor {
    private Iterator<Long> added;
    private Iterator<Long> addedNodeIterator;

    public TxIteratorNodeCursor(TransactionState state, Consumer<TxIteratorNodeCursor> cache) {
        super(state, cache);
    }

    public TxIteratorNodeCursor init(Cursor<NodeItem> nodeCursor, Iterator<Long> addedNodeIterator) {
        super.init(nodeCursor);
        this.nodeIsAddedInThisTx = false;
        this.addedNodeIterator = addedNodeIterator;
        this.added = null;
        return this;
    }

    @Override
    public boolean next() {
        if (this.added == null) {
            while (this.cursor.next()) {
                this.id = ((NodeItem)this.cursor.get()).id();
                if (this.state.nodeIsDeletedInThisTx(this.id)) {
                    this.id = -1L;
                    continue;
                }
                this.nodeState = this.state.getNodeState(((NodeItem)this.cursor.get()).id());
                return true;
            }
            this.added = this.addedNodeIterator;
            this.nodeIsAddedInThisTx = true;
        }
        if (this.added.hasNext()) {
            this.id = this.added.next();
            this.nodeState = this.state.getNodeState(this.id);
            return true;
        }
        this.id = -1L;
        this.nodeState = null;
        return false;
    }
}

