/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import java.util.Iterator;
import java.util.function.Consumer;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.cursor.TxAbstractPropertyCursor;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.StorageProperty;

public class TxAllPropertyCursor
extends TxAbstractPropertyCursor {
    private Iterator<StorageProperty> added;

    public TxAllPropertyCursor(Consumer<TxAbstractPropertyCursor> instanceCache) {
        super(instanceCache);
    }

    @Override
    public boolean next() {
        if (this.added == null) {
            while (this.cursor.next()) {
                int propertyKeyId = ((PropertyItem)this.cursor.get()).propertyKeyId();
                StorageProperty changedProperty = this.state.getChangedProperty(propertyKeyId);
                if (changedProperty != null) {
                    this.property = (DefinedProperty)changedProperty;
                    return true;
                }
                if (this.state.isPropertyRemoved(propertyKeyId)) continue;
                this.property = Property.property(propertyKeyId, ((PropertyItem)this.cursor.get()).value());
                return true;
            }
            this.added = this.state.addedProperties();
        }
        if (this.added != null && this.added.hasNext()) {
            this.property = (DefinedProperty)this.added.next();
            return true;
        }
        this.property = null;
        return false;
    }

    @Override
    public void close() {
        this.added = null;
        super.close();
    }
}

