/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import java.util.function.Consumer;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.txstate.PropertyContainerState;

public abstract class TxAbstractPropertyCursor
implements Cursor<PropertyItem>,
PropertyItem {
    private final Consumer<TxAbstractPropertyCursor> instanceCache;
    protected Cursor<PropertyItem> cursor;
    protected DefinedProperty property;
    protected PropertyContainerState state;

    public TxAbstractPropertyCursor(Consumer<TxAbstractPropertyCursor> instanceCache) {
        this.instanceCache = instanceCache;
    }

    public Cursor<PropertyItem> init(Cursor<PropertyItem> cursor, PropertyContainerState state) {
        this.cursor = cursor;
        this.state = state;
        return this;
    }

    @Override
    public PropertyItem get() {
        if (this.property == null) {
            throw new IllegalStateException();
        }
        return this;
    }

    @Override
    public void close() {
        this.cursor.close();
        this.cursor = null;
        this.property = null;
        this.instanceCache.accept(this);
    }

    @Override
    public int propertyKeyId() {
        return this.property.propertyKeyId();
    }

    @Override
    public Object value() {
        return this.property.value();
    }
}

