/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Comparator;
import org.neo4j.helpers.MathUtil;
import org.neo4j.helpers.Strings;
import org.neo4j.kernel.impl.api.PropertyValueComparator;

public class PropertyValueComparison {
    public static final Object LOWEST_OBJECT = new Object(){

        public String toString() {
            return "";
        }
    };
    public static final PropertyValueComparator<Object> COMPARE_VALUES = new AnyPropertyValueComparator();
    public static final PropertyValueComparator<Number> COMPARE_NUMBERS = new NumberPropertyValueComparator();
    public static final PropertyValueComparator<Object> COMPARE_STRINGS = new StringPropertyValueComparator();
    public static final PropertyValueComparator<SuperType> COMPARE_SUPER_TYPE = new PropertyValueSuperTypeComparator();

    private static class StringPropertyValueComparator
    extends PropertyValueComparator<Object> {
        private StringPropertyValueComparator() {
        }

        @Override
        public int compare(Object left2, Object right2) {
            return this.convert(left2).compareTo(this.convert(right2));
        }

        private String convert(Object value) {
            Class<?> clazz = value.getClass();
            if (clazz.equals(String.class) || clazz.equals(Character.class)) {
                return value.toString();
            }
            throw new IllegalArgumentException(String.format("Cannot compare %s as a string", value));
        }
    }

    private static class NumberPropertyValueComparator
    extends PropertyValueComparator<Number> {
        private NumberPropertyValueComparator() {
        }

        @Override
        public int compare(Number left2, Number right2) {
            Class<?> rightClazz;
            Class<?> leftClazz = left2.getClass();
            if (leftClazz == (rightClazz = right2.getClass())) {
                return ((Comparable)((Object)left2)).compareTo(right2);
            }
            if (left2 instanceof Double || left2 instanceof Float) {
                double lhs = left2.doubleValue();
                if (right2 instanceof Long) {
                    long rhs = right2.longValue();
                    return MathUtil.compareDoubleAgainstLong(lhs, rhs);
                }
                return Double.compare(lhs, right2.doubleValue());
            }
            if (right2 instanceof Double || right2 instanceof Float) {
                double rhs = right2.doubleValue();
                if (left2 instanceof Long) {
                    long lhs = left2.longValue();
                    return MathUtil.compareLongAgainstDouble(lhs, rhs);
                }
                return Double.compare(left2.doubleValue(), rhs);
            }
            if (leftClazz.equals(Long.class)) {
                if (rightClazz.equals(Integer.class) || rightClazz.equals(Short.class) || rightClazz.equals(Byte.class)) {
                    return Long.compare(left2.longValue(), right2.longValue());
                }
            } else if (leftClazz.equals(Integer.class)) {
                if (rightClazz.equals(Long.class)) {
                    return Long.compare(left2.longValue(), right2.longValue());
                }
                if (rightClazz.equals(Short.class) || rightClazz.equals(Byte.class)) {
                    return Integer.compare(left2.intValue(), right2.intValue());
                }
            } else if (leftClazz.equals(Short.class)) {
                if (rightClazz.equals(Long.class)) {
                    return Long.compare(left2.longValue(), right2.longValue());
                }
                if (rightClazz.equals(Integer.class)) {
                    return Integer.compare(left2.intValue(), right2.intValue());
                }
                if (rightClazz.equals(Byte.class)) {
                    return Short.compare(left2.shortValue(), right2.shortValue());
                }
            } else if (leftClazz.equals(Byte.class)) {
                if (rightClazz.equals(Long.class)) {
                    return Long.compare(left2.longValue(), right2.longValue());
                }
                if (rightClazz.equals(Integer.class)) {
                    return Integer.compare(left2.intValue(), right2.intValue());
                }
                if (rightClazz.equals(Short.class)) {
                    return Short.compare(left2.shortValue(), right2.shortValue());
                }
            }
            throw new IllegalArgumentException(String.format("Comparing numbers %s and %s (with type %s and %s) is not supported", left2, right2, leftClazz, rightClazz));
        }
    }

    private static class PropertyValueSuperTypeComparator
    extends PropertyValueComparator<SuperType> {
        private PropertyValueSuperTypeComparator() {
        }

        @Override
        public int compare(SuperType left2, SuperType right2) {
            return Integer.compare(left2.typeId, right2.typeId);
        }
    }

    private static class AnyPropertyValueComparator
    extends PropertyValueComparator<Object> {
        private AnyPropertyValueComparator() {
        }

        @Override
        public int compare(Object left2, Object right2) {
            SuperType rightType;
            SuperType leftType = SuperType.ofValue(left2);
            int cmp = COMPARE_SUPER_TYPE.compare(leftType, rightType = SuperType.ofValue(right2));
            if (cmp == 0) {
                switch (leftType) {
                    case NUMBER: {
                        return COMPARE_NUMBERS.compare((Number)left2, (Number)right2);
                    }
                    case STRING: {
                        return left2.toString().compareTo(right2.toString());
                    }
                    case BOOLEAN: {
                        return Boolean.compare((Boolean)left2, (Boolean)right2);
                    }
                }
                String leftString = Strings.prettyPrint(left2);
                String rightString = Strings.prettyPrint(right2);
                return leftString.compareTo(rightString);
            }
            return cmp;
        }
    }

    public static final class Limit<T> {
        public final T value;
        public final boolean isInclusive;

        private Limit(T value, boolean isInclusive) {
            this.value = value;
            this.isInclusive = isInclusive;
        }

        public <X extends T> X castValue(Class<X> clazz) {
            return clazz.cast(this.value);
        }

        public static <T> Limit<T> inclusive(T value) {
            return new Limit<T>(value, true);
        }

        public static <T> Limit<T> exclusive(T value) {
            return new Limit<T>(value, false);
        }
    }

    public static enum SuperType {
        OTHER(0, Limit.inclusive(LOWEST_OBJECT), Limit.exclusive("")),
        STRING(1, Limit.inclusive(""), Limit.exclusive(false)),
        BOOLEAN(2, Limit.inclusive(false), Limit.inclusive(true)),
        NUMBER(3, Limit.inclusive(Double.NEGATIVE_INFINITY), Limit.inclusive(Double.NaN));

        public final int typeId;
        public final Limit<Object> lowLimit;
        public final Limit<Object> highLimit;
        public static Comparator<SuperType> TYPE_ID_COMPARATOR;

        private SuperType(int typeId, Limit<Object> lowLimit, Limit<Object> highLimit) {
            this.typeId = typeId;
            this.lowLimit = lowLimit;
            this.highLimit = highLimit;
        }

        public boolean isSuperTypeOf(Object value) {
            return this == SuperType.ofValue(value);
        }

        public static SuperType ofValue(Object value) {
            if (null == value) {
                throw new NullPointerException("null is not a valid property value and hence has no PropertyValueComparison.SuperType");
            }
            if (value instanceof String) {
                return STRING;
            }
            if (value instanceof Number) {
                return NUMBER;
            }
            if (value instanceof Boolean) {
                return BOOLEAN;
            }
            if (value instanceof Character) {
                return STRING;
            }
            return OTHER;
        }

        static {
            TYPE_ID_COMPARATOR = new Comparator<SuperType>(){

                @Override
                public int compare(SuperType left2, SuperType right2) {
                    return left2.typeId - right2.typeId;
                }
            };
        }
    }
}

