/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.register.Register;

public interface CountsAccessor
extends CountsVisitor.Visitable {
    public Register.DoubleLongRegister nodeCount(int var1, Register.DoubleLongRegister var2);

    public Register.DoubleLongRegister relationshipCount(int var1, int var2, int var3, Register.DoubleLongRegister var4);

    public Register.DoubleLongRegister indexUpdatesAndSize(int var1, int var2, Register.DoubleLongRegister var3);

    public Register.DoubleLongRegister indexSample(int var1, int var2, Register.DoubleLongRegister var3);

    public static final class Initializer
    implements CountsVisitor {
        private final Updater updater;
        private final IndexStatsUpdater stats;

        public Initializer(Updater updater, IndexStatsUpdater stats) {
            this.updater = updater;
            this.stats = stats;
        }

        @Override
        public void visitNodeCount(int labelId, long count2) {
            this.updater.incrementNodeCount(labelId, count2);
        }

        @Override
        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count2) {
            this.updater.incrementRelationshipCount(startLabelId, typeId, endLabelId, count2);
        }

        @Override
        public void visitIndexStatistics(int labelId, int propertyKeyId, long updates, long size2) {
            this.stats.replaceIndexUpdateAndSize(labelId, propertyKeyId, updates, size2);
        }

        @Override
        public void visitIndexSample(int labelId, int propertyKeyId, long unique, long size2) {
            this.stats.replaceIndexSample(labelId, propertyKeyId, unique, size2);
        }
    }

    public static interface IndexStatsUpdater
    extends AutoCloseable {
        public void replaceIndexUpdateAndSize(int var1, int var2, long var3, long var5);

        public void replaceIndexSample(int var1, int var2, long var3, long var5);

        public void incrementIndexUpdates(int var1, int var2, long var3);

        @Override
        public void close();
    }

    public static interface Updater
    extends AutoCloseable {
        public void incrementNodeCount(int var1, long var2);

        public void incrementRelationshipCount(int var1, int var2, int var3, long var4);

        @Override
        public void close();
    }
}

