/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.annotations;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.neo4j.io.fs.FileUtils;

public abstract class AnnotationProcessor
extends AbstractProcessor {
    private static Pattern nl = Pattern.compile("\n");

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                    if (!annotationMirror.getAnnotationType().asElement().equals(typeElement)) continue;
                    try {
                        this.process(typeElement, element, annotationMirror, this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotationMirror));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Internal error: " + e.toString(), element, annotationMirror);
                    }
                }
            }
        }
        return false;
    }

    protected final void warn(Element element, String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, element);
    }

    protected final void warn(Element element, AnnotationMirror annotation, String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, element, annotation);
    }

    protected final void error(Element element, String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    protected final void error(Element element, AnnotationMirror annotation, String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element, annotation);
    }

    protected abstract void process(TypeElement var1, Element var2, AnnotationMirror var3, Map<? extends ExecutableElement, ? extends AnnotationValue> var4) throws IOException;

    void addTo(String line, String ... path) throws IOException {
        File file;
        FileObject fo = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.path(path));
        URI uri = fo.toUri();
        try {
            file = new File(uri);
        }
        catch (Exception e) {
            file = new File(uri.toString());
        }
        if (file.exists()) {
            for (String previous : nl.split(fo.getCharContent(true), 0)) {
                if (!line.equals(previous)) continue;
                return;
            }
        } else {
            file.getParentFile().mkdirs();
        }
        try (PrintWriter writer = FileUtils.newFilePrintWriter(file, StandardCharsets.UTF_8);){
            writer.append(line).append("\n");
        }
    }

    private String path(String[] path) {
        StringBuilder filename = new StringBuilder();
        String sep = "";
        for (String part : path) {
            filename.append(sep).append(part);
            sep = "/";
        }
        return filename.toString();
    }
}

