/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategy;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.DependenciesProxy;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class KernelExtensions
extends DependencyResolver.Adapter
implements Lifecycle {
    private final KernelContext kernelContext;
    private final List<KernelExtensionFactory<?>> kernelExtensionFactories;
    private final Dependencies dependencies;
    private final LifeSupport life = new LifeSupport();
    private final UnsatisfiedDependencyStrategy unsatisfiedDepencyStrategy;

    public KernelExtensions(KernelContext kernelContext, Iterable<KernelExtensionFactory<?>> kernelExtensionFactories, Dependencies dependencies2, UnsatisfiedDependencyStrategy unsatisfiedDependencyStrategy) {
        this.kernelContext = kernelContext;
        this.unsatisfiedDepencyStrategy = unsatisfiedDependencyStrategy;
        this.kernelExtensionFactories = Iterables.addAll(new ArrayList(), kernelExtensionFactories);
        this.dependencies = dependencies2;
    }

    @Override
    public void init() throws Throwable {
        for (KernelExtensionFactory<?> kernelExtensionFactory : this.kernelExtensionFactories) {
            Object kernelExtensionDependencies = this.getKernelExtensionDependencies(kernelExtensionFactory);
            try {
                Lifecycle dependency = kernelExtensionFactory.newInstance(this.kernelContext, kernelExtensionDependencies);
                Objects.requireNonNull(dependency, kernelExtensionFactory.toString() + " returned a null " + "KernelExtension");
                this.life.add(this.dependencies.satisfyDependency(dependency));
            }
            catch (UnsatisfiedDependencyException e) {
                this.unsatisfiedDepencyStrategy.handle(kernelExtensionFactory, e);
            }
        }
        this.life.init();
    }

    @Override
    public void start() throws Throwable {
        this.life.start();
    }

    @Override
    public void stop() throws Throwable {
        this.life.stop();
    }

    @Override
    public void shutdown() throws Throwable {
        this.life.shutdown();
    }

    public boolean isRegistered(Class<?> kernelExtensionFactoryClass) {
        for (KernelExtensionFactory<?> kernelExtensionFactory : this.kernelExtensionFactories) {
            if (!kernelExtensionFactoryClass.isInstance(kernelExtensionFactory)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws IllegalArgumentException {
        Iterable<Lifecycle> filtered2 = Iterables.filter(new TypeFilter<T>(type), this.life.getLifecycleInstances());
        Iterable casted = Iterables.map(new CastFunction<T>(type), filtered2);
        return selector.select(type, casted);
    }

    private Object getKernelExtensionDependencies(KernelExtensionFactory<?> factory) {
        Class configurationClass = (Class)((ParameterizedType)factory.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return DependenciesProxy.dependencies(this.dependencies, configurationClass);
    }

    public Iterable<KernelExtensionFactory<?>> listFactories() {
        return this.kernelExtensionFactories;
    }

    private class CastFunction<T>
    implements Function<Object, T> {
        private final Class<T> type;

        public CastFunction(Class<T> type) {
            this.type = type;
        }

        @Override
        public T apply(Object o) {
            return this.type.cast(o);
        }
    }

    private static class TypeFilter<T>
    implements Predicate {
        private final Class<T> type;

        public TypeFilter(Class<T> type) {
            this.type = type;
        }

        public boolean test(Object extension2) {
            return this.type.isInstance(extension2);
        }
    }
}

