/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration.docs;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.kernel.configuration.Group;
import org.neo4j.kernel.configuration.Internal;
import org.neo4j.kernel.configuration.Obsoleted;
import org.neo4j.kernel.configuration.docs.SettingDescription;

public class SettingsDescription {
    private final String name;
    private final String description;
    private final List<SettingDescription> settings;

    public static SettingsDescription describe(Class<?> settingClass) {
        String classDescription = settingClass.isAnnotationPresent(Description.class) ? settingClass.getAnnotation(Description.class).value() : "List of configuration settings";
        String settingsName = settingClass.getName().replace("$", "-");
        Object instance = null;
        for (Class<?> cls = settingClass; cls != null; cls = cls.getSuperclass()) {
            if (!cls.isAnnotationPresent(Group.class)) continue;
            instance = SettingsDescription.groupInstance(settingClass);
            break;
        }
        LinkedList<SettingDescription> settings = new LinkedList<SettingDescription>();
        for (Field field2 : settingClass.getFields()) {
            SettingsDescription.fieldAsSetting(settingClass, instance, field2).ifPresent(setting -> {
                String deprecationMessage;
                String mandatoryMessage;
                String defaultValue;
                String validationMessage;
                String description;
                String name2;
                block2: {
                    name2 = setting.name();
                    description = field2.getAnnotation(Description.class).value();
                    validationMessage = setting.toString();
                    defaultValue = null;
                    mandatoryMessage = null;
                    deprecationMessage = field2.isAnnotationPresent(Obsoleted.class) ? field2.getAnnotation(Obsoleted.class).value() : (field2.isAnnotationPresent(Deprecated.class) ? "The " + name2 + " configuration setting has been deprecated." : null);
                    try {
                        Object rawDefault = setting.apply(from2 -> null);
                        defaultValue = rawDefault != null ? rawDefault.toString() : null;
                    }
                    catch (IllegalArgumentException iae) {
                        if (!iae.toString().contains("mandatory")) break block2;
                        mandatoryMessage = "The " + name2 + " configuration setting is mandatory.";
                    }
                }
                settings.add(new SettingDescription("config_" + name2.replace("(", "").replace(")", ""), name2, description, mandatoryMessage, deprecationMessage, validationMessage, defaultValue, deprecationMessage != null, mandatoryMessage != null, defaultValue != null));
            });
        }
        return new SettingsDescription(settingsName, classDescription, settings);
    }

    private static Object groupInstance(Class<?> settingClass) {
        try {
            return settingClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Optional<Setting<?>> fieldAsSetting(Class<?> settingClass, Object instance, Field field2) {
        Setting setting;
        try {
            setting = (Setting)field2.get(instance);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        if (field2.isAnnotationPresent(Internal.class)) {
            return Optional.empty();
        }
        if (!field2.isAnnotationPresent(Description.class)) {
            throw new RuntimeException(String.format("Public setting `%s` is missing description in %s.", setting.name(), settingClass.getName()));
        }
        return Optional.of(setting);
    }

    public SettingsDescription(String name2, String description, List<SettingDescription> settings) {
        this.name = name2;
        this.description = description;
        this.settings = settings;
    }

    public Stream<SettingDescription> settings() {
        return this.settings.stream().sorted((a, b) -> a.name().compareTo(b.name()));
    }

    public String id() {
        return "config-" + this.name();
    }

    public String description() {
        return this.description;
    }

    public String name() {
        return this.name;
    }

    public SettingsDescription union(SettingsDescription other2) {
        ArrayList<SettingDescription> union2 = new ArrayList<SettingDescription>(this.settings);
        union2.addAll(other2.settings);
        return new SettingsDescription(this.name, this.description, union2);
    }
}

