/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration.docs;

import java.util.Objects;
import java.util.function.Function;

public final class SettingDescription {
    private final String id;
    private final String name;
    private final String description;
    private final String mandatoryDescription;
    private final String deprecationDescription;
    private final String validationDescription;
    private final String defaultValue;
    private final boolean isDeprecated;
    private final boolean isMandatory;
    private final boolean hasDefault;

    public SettingDescription(String id, String name2, String description, String mandatoryDescription, String deprecationDescription, String validationDescription, String defaultValue, boolean isDeprecated, boolean isMandatory, boolean hasDefault) {
        this.id = id;
        this.mandatoryDescription = mandatoryDescription;
        this.deprecationDescription = deprecationDescription;
        this.validationDescription = validationDescription;
        this.defaultValue = defaultValue;
        this.isDeprecated = isDeprecated;
        this.name = name2.replace("{", "\\{").replace("}", "\\}");
        this.description = description;
        this.isMandatory = isMandatory;
        this.hasDefault = hasDefault;
    }

    public SettingDescription(String id, String name2, String description) {
        this(id, name2, description, null, null, null, null, false, false, false);
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public boolean hasDefault() {
        return this.hasDefault;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public String mandatoryDescription() {
        return this.mandatoryDescription;
    }

    public String deprecationMessage() {
        return this.deprecationDescription;
    }

    public String validationMessage() {
        return this.validationDescription;
    }

    public SettingDescription formatted(Function<String, String> format2) {
        Function<String, String> f = str2 -> str2 == null ? null : (String)format2.apply((String)str2);
        return new SettingDescription(this.id, this.name, f.apply(this.description), f.apply(this.mandatoryDescription), f.apply(this.deprecationDescription), this.validationDescription, this.defaultValue, this.isDeprecated, this.isMandatory, this.hasDefault);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SettingDescription that = (SettingDescription)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description);
    }

    public String toString() {
        return "SettingDescription{id='" + this.id() + "', name='" + this.name + "', description='" + this.description + "'}";
    }
}

