/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration.docs;

import java.io.File;
import java.util.List;
import java.util.function.Function;
import org.neo4j.helpers.Args;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.docs.SettingsDocumenter;

public class GenerateConfigDocumentation {
    private static Function<String, Class<?>> classFromString = className -> {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    };

    public static void main(String[] argv) throws Exception {
        Args arguments2 = Args.parse(argv);
        File output = arguments2.has("o") ? new File(arguments2.get("o")) : null;
        List<String> settingsClasses = arguments2.orphans();
        if (settingsClasses.size() == 0) {
            System.out.println("Usage: GenerateConfigDocumentation [-o output file] SETTINGS_CLASS..");
            System.exit(0);
        }
        String doc2 = new SettingsDocumenter().document(settingsClasses.stream().map(classFromString));
        if (output != null) {
            System.out.println("Saving docs in '" + output.getAbsolutePath() + "'.");
            FileUtils.writeToFile(output, doc2, false);
        } else {
            System.out.println(doc2);
        }
    }
}

