/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.ConfigValues;
import org.neo4j.kernel.configuration.Group;

public class GroupSettingSupport {
    private final String key;
    private final String prefix;

    public static Function<ConfigValues, Stream<String>> enumerate(Class<?> settingsGroup) {
        Pattern pattern = Pattern.compile(Pattern.quote(GroupSettingSupport.groupPrefix(settingsGroup)) + "\\.([^\\.]+)\\.(.+)");
        return values2 -> values2.rawConfiguration().stream().map(entry -> pattern.matcher((CharSequence)entry.first())).filter(Matcher::matches).map(match -> match.group(1)).distinct().sorted();
    }

    private static String groupPrefix(Class<?> groupClass) {
        return groupClass.getAnnotation(Group.class).value();
    }

    public GroupSettingSupport(Class<?> groupClass, Object groupKey) {
        this(GroupSettingSupport.groupPrefix(groupClass), groupKey);
    }

    public GroupSettingSupport(String groupPrefix, Object groupKey) {
        this.prefix = groupPrefix;
        this.key = String.format("%s.%s", this.prefix, groupKey);
    }

    public <T> Setting<T> scope(final Setting<T> inner2) {
        return new Setting<T>(){

            @Override
            public String name() {
                return this.scopeToGroup(inner2.name());
            }

            @Override
            public String getDefaultValue() {
                return inner2.getDefaultValue();
            }

            @Override
            public T from(Configuration config) {
                return config.get(this);
            }

            @Override
            public T apply(Function<String, String> config) {
                return inner2.apply(key -> (String)config.apply(this.scopeToGroup((String)key)));
            }

            public String toString() {
                return inner2.toString();
            }

            public int hashCode() {
                return this.name().hashCode();
            }

            public boolean equals(Object obj) {
                return obj != null && obj instanceof Setting && this.name().equals(((Setting)obj).name());
            }

            private String scopeToGroup(String key) {
                return String.format("%s.%s", GroupSettingSupport.this.key, key);
            }
        };
    }
}

