/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.AnnotatedFieldHarvester;

public class ConfigurationValidator {
    private AnnotatedFieldHarvester fieldHarvester = new AnnotatedFieldHarvester();
    private Map<String, Setting<?>> settings;

    public ConfigurationValidator(Iterable<Class<?>> settingsClasses) {
        this.settings = this.getSettingsFrom(settingsClasses);
    }

    public void validate(Map<String, String> rawConfig) {
        for (Setting<?> setting : this.settings.values()) {
            setting.apply(rawConfig::get);
        }
    }

    private Map<String, Setting<?>> getSettingsFrom(Iterable<Class<?>> settingsClasses) {
        HashMap settings = new HashMap();
        for (Class<?> clazz : settingsClasses) {
            for (Pair<Field, Setting> field2 : this.fieldHarvester.findStatic(clazz, Setting.class)) {
                settings.put(field2.other().name(), field2.other());
            }
        }
        return settings;
    }
}

