/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.logging.Log;

public class BaseConfigurationMigrator
implements ConfigurationMigrator {
    private final List<Migration> migrations = new ArrayList<Migration>();

    public static Migration valueChanged(String key, String oldValue, String newValue, String deprecationMessage) {
        return new ConfigValueChanged(key, oldValue, newValue, deprecationMessage);
    }

    public static Migration propertyRenamed(String oldKey, String newKey, String deprecationMessage) {
        return new PropertyRenamed(oldKey, newKey, deprecationMessage);
    }

    public void add(Migration migration2) {
        this.migrations.add(migration2);
    }

    @Override
    public Map<String, String> apply(Map<String, String> rawConfiguration, Log log) {
        boolean printedDeprecationMessage = false;
        for (Migration migration2 : this.migrations) {
            if (!migration2.appliesTo(rawConfiguration)) continue;
            if (!printedDeprecationMessage) {
                printedDeprecationMessage = true;
                log.warn("WARNING! Deprecated configuration options used. See manual for details");
            }
            rawConfiguration = migration2.apply(rawConfiguration);
            log.warn(migration2.getDeprecationMessage());
        }
        return rawConfiguration;
    }

    public static class ConfigValueChanged
    implements Migration {
        private final String propertyKey;
        private final String oldValue;
        private final String newValue;
        private final String message;

        public ConfigValueChanged(String propertyKey, String oldValue, String newValue, String message) {
            this.propertyKey = propertyKey;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.message = message;
        }

        @Override
        public boolean appliesTo(Map<String, String> rawConfiguration) {
            return rawConfiguration.containsKey(this.propertyKey) && rawConfiguration.get(this.propertyKey).equalsIgnoreCase(this.oldValue);
        }

        @Override
        public Map<String, String> apply(Map<String, String> rawConfiguration) {
            rawConfiguration.put(this.propertyKey, this.newValue);
            return rawConfiguration;
        }

        @Override
        public String getDeprecationMessage() {
            return this.message;
        }
    }

    public static class PropertyRenamed
    extends SpecificPropertyMigration {
        private final String newKey;

        public PropertyRenamed(String oldKey, String newKey, String deprecationMessage) {
            super(oldKey, deprecationMessage);
            this.newKey = newKey;
        }

        @Override
        public void setValueWithOldSetting(String value, Map<String, String> rawConfiguration) {
            rawConfiguration.put(this.newKey, value);
        }
    }

    public static abstract class SpecificPropertyMigration
    implements Migration {
        private final String propertyKey;
        private final String deprecationMessage;

        public SpecificPropertyMigration(String propertyKey, String deprecationMessage) {
            this.propertyKey = propertyKey;
            this.deprecationMessage = deprecationMessage;
        }

        @Override
        public boolean appliesTo(Map<String, String> rawConfiguration) {
            return rawConfiguration.containsKey(this.propertyKey);
        }

        @Override
        public Map<String, String> apply(Map<String, String> rawConfiguration) {
            String value = rawConfiguration.get(this.propertyKey);
            rawConfiguration.remove(this.propertyKey);
            this.setValueWithOldSetting(value, rawConfiguration);
            return rawConfiguration;
        }

        @Override
        public String getDeprecationMessage() {
            return this.deprecationMessage;
        }

        public abstract void setValueWithOldSetting(String var1, Map<String, String> var2);
    }

    public static interface Migration {
        public boolean appliesTo(Map<String, String> var1);

        public Map<String, String> apply(Map<String, String> var1);

        public String getDeprecationMessage();
    }
}

