/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.AnnotatedFieldHarvester;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.logging.Log;

public class AnnotationBasedConfigurationMigrator
implements ConfigurationMigrator {
    private ArrayList<ConfigurationMigrator> migrators = new ArrayList();
    private AnnotatedFieldHarvester fieldHarvester = new AnnotatedFieldHarvester();

    public AnnotationBasedConfigurationMigrator(Iterable<Class<?>> settingsClasses) {
        for (Class<?> settingsClass : settingsClasses) {
            for (Pair<Field, ConfigurationMigrator> field2 : this.fieldHarvester.findStatic(settingsClass, ConfigurationMigrator.class, Migrator.class)) {
                this.migrators.add(field2.other());
            }
        }
    }

    @Override
    public Map<String, String> apply(Map<String, String> rawConfiguration, Log log) {
        for (ConfigurationMigrator migrator : this.migrators) {
            rawConfiguration = migrator.apply(rawConfiguration, log);
        }
        return rawConfiguration;
    }
}

