/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.lang.management.ManagementFactory;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.builtinprocs.AlterUserPasswordProcedure;
import org.neo4j.kernel.builtinprocs.JmxQueryProcedure;
import org.neo4j.kernel.builtinprocs.ListComponentsProcedure;
import org.neo4j.kernel.builtinprocs.ListConstraintsProcedure;
import org.neo4j.kernel.builtinprocs.ListIndexesProcedure;
import org.neo4j.kernel.builtinprocs.ListLabelsProcedure;
import org.neo4j.kernel.builtinprocs.ListProceduresProcedure;
import org.neo4j.kernel.builtinprocs.ListPropertyKeysProcedure;
import org.neo4j.kernel.builtinprocs.ListRelationshipTypesProcedure;
import org.neo4j.kernel.impl.proc.Procedures;

public class BuiltInProcedures
implements ThrowingConsumer<Procedures, ProcedureException> {
    private final String neo4jVersion;
    private final String neo4jEdition;

    public BuiltInProcedures(String neo4jVersion, String neo4jEdition) {
        this.neo4jVersion = neo4jVersion;
        this.neo4jEdition = neo4jEdition;
    }

    @Override
    public void accept(Procedures procs) throws ProcedureException {
        procs.register(new ListLabelsProcedure(ProcedureSignature.procedureName("db", "labels")));
        procs.register(new ListPropertyKeysProcedure(ProcedureSignature.procedureName("db", "propertyKeys")));
        procs.register(new ListRelationshipTypesProcedure(ProcedureSignature.procedureName("db", "relationshipTypes")));
        procs.register(new ListIndexesProcedure(ProcedureSignature.procedureName("db", "indexes")));
        procs.register(new ListConstraintsProcedure(ProcedureSignature.procedureName("db", "constraints")));
        procs.register(new ListProceduresProcedure(ProcedureSignature.procedureName("dbms", "procedures")));
        procs.register(new ListComponentsProcedure(ProcedureSignature.procedureName("dbms", "components"), this.neo4jVersion, this.neo4jEdition));
        procs.register(new JmxQueryProcedure(ProcedureSignature.procedureName("dbms", "queryJmx"), ManagementFactory.getPlatformMBeanServer()));
        procs.register(new AlterUserPasswordProcedure(ProcedureSignature.procedureName("dbms", "changePassword")));
    }
}

