/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.CharProperty;
import org.neo4j.kernel.api.properties.DefinedProperty;

final class StringProperty
extends DefinedProperty
implements DefinedProperty.WithStringValue {
    private final String value;

    StringProperty(int propertyKeyId, String value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    @Override
    public boolean valueEquals(Object other2) {
        return StringProperty.valueEquals(this.value, other2);
    }

    static boolean valueEquals(String value, Object other2) {
        if (other2 instanceof String) {
            return value.equals(other2);
        }
        if (other2 instanceof Character) {
            Character that = (Character)other2;
            return value.length() == 1 && value.charAt(0) == that.charValue();
        }
        return false;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    int valueHash() {
        return this.value.hashCode();
    }

    @Override
    boolean hasEqualValue(DefinedProperty other2) {
        if (other2 instanceof StringProperty) {
            StringProperty that = (StringProperty)other2;
            return this.value.equals(that.value);
        }
        if (other2 instanceof CharProperty) {
            CharProperty that = (CharProperty)other2;
            return this.value.length() == 1 && that.value == this.value.charAt(0);
        }
        return false;
    }

    @Override
    public String stringValue() {
        return this.value;
    }
}

