/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.CharArrayProperty;
import org.neo4j.kernel.api.properties.DefinedProperty;

class StringArrayProperty
extends DefinedProperty {
    final String[] value;

    StringArrayProperty(int propertyKeyId, String[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public String[] value() {
        return (String[])this.value.clone();
    }

    @Override
    public boolean valueEquals(Object other2) {
        String[] value = this.value;
        return StringArrayProperty.valueEquals(value, other2);
    }

    static boolean valueEquals(String[] value, Object other2) {
        if (other2 instanceof String[]) {
            return Arrays.equals(value, (String[])other2);
        }
        if (other2 instanceof char[]) {
            return CharArrayProperty.eq(value, (char[])other2);
        }
        if (other2 instanceof Character[]) {
            Character[] that = (Character[])other2;
            if (value.length == that.length) {
                for (int i = 0; i < that.length; ++i) {
                    String str2 = value[i];
                    Character character = that[i];
                    if (character != null && str2.length() == 1 && str2.charAt(0) == character.charValue()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    int valueHash() {
        return StringArrayProperty.hash(this.value);
    }

    static int hash(String[] value) {
        return Arrays.hashCode(value);
    }

    @Override
    boolean hasEqualValue(DefinedProperty other2) {
        if (other2 instanceof StringArrayProperty) {
            StringArrayProperty that = (StringArrayProperty)other2;
            return Arrays.equals(this.value, that.value);
        }
        if (other2 instanceof CharArrayProperty) {
            CharArrayProperty that = (CharArrayProperty)other2;
            return CharArrayProperty.eq(this.value, that.value);
        }
        return false;
    }
}

