/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.helpers.MathUtil;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.FloatingPointNumberProperty;
import org.neo4j.kernel.api.properties.NumberProperty;

abstract class IntegralNumberProperty
extends NumberProperty
implements DefinedProperty.WithLongValue {
    IntegralNumberProperty(int propertyKeyId) {
        super(propertyKeyId);
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    @Override
    final int valueHash() {
        long value = this.longValue();
        return (int)(value ^ value >>> 32);
    }

    @Override
    public final boolean valueEquals(Object other2) {
        if (other2 instanceof Number) {
            Number that = (Number)other2;
            if (other2 instanceof Double || other2 instanceof Float) {
                return MathUtil.numbersEqual(that.doubleValue(), this.longValue());
            }
            return this.longValue() == that.longValue();
        }
        return false;
    }

    @Override
    final boolean hasEqualValue(DefinedProperty other2) {
        if (other2 instanceof IntegralNumberProperty) {
            IntegralNumberProperty that = (IntegralNumberProperty)other2;
            return this.longValue() == that.longValue();
        }
        if (other2 instanceof FloatingPointNumberProperty) {
            FloatingPointNumberProperty that = (FloatingPointNumberProperty)other2;
            return MathUtil.numbersEqual(that.doubleValue(), this.longValue());
        }
        return false;
    }
}

