/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.ArrayValue;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.FloatingPointArrayProperty;

abstract class IntegralArrayProperty
extends DefinedProperty
implements ArrayValue.IntegralArray {
    IntegralArrayProperty(int propertyKeyId) {
        super(propertyKeyId);
    }

    @Override
    public abstract int length();

    @Override
    public abstract long longValue(int var1);

    @Override
    final int valueHash() {
        return IntegralArrayProperty.hash(this);
    }

    static int hash(ArrayValue.IntegralArray value) {
        int result2 = 1;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            long element = value.longValue(i);
            int elementHash = (int)(element ^ element >>> 32);
            result2 = 31 * result2 + elementHash;
        }
        return result2;
    }

    @Override
    public final boolean valueEquals(Object other2) {
        return IntegralArrayProperty.valueEquals(this, other2);
    }

    static boolean valueEquals(ArrayValue.IntegralArray value, Object other2) {
        if (other2 instanceof long[]) {
            return IntegralArrayProperty.numbersEqual(value, (ArrayValue.IntegralArray)new ArrayValue.LongArray((long[])other2));
        }
        if (other2 instanceof int[]) {
            return IntegralArrayProperty.numbersEqual(value, (ArrayValue.IntegralArray)new ArrayValue.IntArray((int[])other2));
        }
        if (other2 instanceof short[]) {
            return IntegralArrayProperty.numbersEqual(value, (ArrayValue.IntegralArray)new ArrayValue.ShortArray((short[])other2));
        }
        if (other2 instanceof byte[]) {
            return IntegralArrayProperty.numbersEqual(value, (ArrayValue.IntegralArray)new ArrayValue.ByteArray((byte[])other2));
        }
        if (other2 instanceof Number[]) {
            Number[] that = (Number[])other2;
            if (that.length == value.length()) {
                if (other2 instanceof Double[] || other2 instanceof Float[]) {
                    return IntegralArrayProperty.numbersEqual(ArrayValue.NumberArray.asFloatingPoint(that), value);
                }
                return IntegralArrayProperty.numbersEqual(value, ArrayValue.NumberArray.asIntegral(that));
            }
        } else {
            if (other2 instanceof double[]) {
                return IntegralArrayProperty.numbersEqual((ArrayValue.FloatingPointArray)new ArrayValue.DoubleArray((double[])other2), value);
            }
            if (other2 instanceof float[]) {
                return IntegralArrayProperty.numbersEqual((ArrayValue.FloatingPointArray)new ArrayValue.FloatArray((float[])other2), value);
            }
        }
        return false;
    }

    @Override
    final boolean hasEqualValue(DefinedProperty other2) {
        if (other2 instanceof IntegralArrayProperty) {
            IntegralArrayProperty that = (IntegralArrayProperty)other2;
            return IntegralArrayProperty.numbersEqual(this, (ArrayValue.IntegralArray)that);
        }
        if (other2 instanceof FloatingPointArrayProperty) {
            FloatingPointArrayProperty that = (FloatingPointArrayProperty)other2;
            return IntegralArrayProperty.numbersEqual((ArrayValue.FloatingPointArray)that, (ArrayValue.IntegralArray)this);
        }
        return false;
    }
}

