/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.helpers.MathUtil;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.IntegralNumberProperty;
import org.neo4j.kernel.api.properties.NumberProperty;

abstract class FloatingPointNumberProperty
extends NumberProperty {
    FloatingPointNumberProperty(int propertyKeyId) {
        super(propertyKeyId);
    }

    @Override
    final int valueHash() {
        long value = (long)this.doubleValue();
        return (int)(value ^ value >>> 32);
    }

    @Override
    public final boolean valueEquals(Object other2) {
        if (other2 instanceof Number) {
            Number that = (Number)other2;
            if (other2 instanceof Double || other2 instanceof Float) {
                return this.doubleValue() == that.doubleValue();
            }
            return MathUtil.numbersEqual(this.doubleValue(), that.longValue());
        }
        return false;
    }

    @Override
    final boolean hasEqualValue(DefinedProperty other2) {
        if (other2 instanceof FloatingPointNumberProperty) {
            FloatingPointNumberProperty that = (FloatingPointNumberProperty)other2;
            return this.doubleValue() == that.doubleValue();
        }
        if (other2 instanceof IntegralNumberProperty) {
            IntegralNumberProperty that = (IntegralNumberProperty)other2;
            return MathUtil.numbersEqual(this.doubleValue(), that.longValue());
        }
        return false;
    }
}

