/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.ArrayValue;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.IntegralArrayProperty;

abstract class FloatingPointArrayProperty
extends DefinedProperty
implements ArrayValue.FloatingPointArray {
    FloatingPointArrayProperty(int propertyKeyId) {
        super(propertyKeyId);
    }

    @Override
    public abstract int length();

    @Override
    public abstract double doubleValue(int var1);

    @Override
    final int valueHash() {
        return FloatingPointArrayProperty.hash(this);
    }

    static int hash(ArrayValue.FloatingPointArray value) {
        int result2 = 1;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            long element = (long)value.doubleValue(i);
            int elementHash = (int)(element ^ element >>> 32);
            result2 = 31 * result2 + elementHash;
        }
        return result2;
    }

    @Override
    public final boolean valueEquals(Object other2) {
        return FloatingPointArrayProperty.valueEquals(this, other2);
    }

    static boolean valueEquals(ArrayValue.FloatingPointArray value, Object other2) {
        if (other2 instanceof double[]) {
            return FloatingPointArrayProperty.numbersEqual(value, new ArrayValue.DoubleArray((double[])other2));
        }
        if (other2 instanceof float[]) {
            return FloatingPointArrayProperty.numbersEqual(value, new ArrayValue.FloatArray((float[])other2));
        }
        if (other2 instanceof Number[]) {
            Number[] that = (Number[])other2;
            if (that.length == value.length()) {
                if (other2 instanceof Double[] || other2 instanceof Float[]) {
                    return FloatingPointArrayProperty.numbersEqual(value, ArrayValue.NumberArray.asFloatingPoint(that));
                }
                return FloatingPointArrayProperty.numbersEqual(value, ArrayValue.NumberArray.asIntegral(that));
            }
        } else {
            if (other2 instanceof long[]) {
                return FloatingPointArrayProperty.numbersEqual(value, (ArrayValue.IntegralArray)new ArrayValue.LongArray((long[])other2));
            }
            if (other2 instanceof int[]) {
                return FloatingPointArrayProperty.numbersEqual(value, (ArrayValue.IntegralArray)new ArrayValue.IntArray((int[])other2));
            }
            if (other2 instanceof short[]) {
                return FloatingPointArrayProperty.numbersEqual(value, (ArrayValue.IntegralArray)new ArrayValue.ShortArray((short[])other2));
            }
            if (other2 instanceof byte[]) {
                return FloatingPointArrayProperty.numbersEqual(value, (ArrayValue.IntegralArray)new ArrayValue.ByteArray((byte[])other2));
            }
        }
        return false;
    }

    @Override
    final boolean hasEqualValue(DefinedProperty other2) {
        if (other2 instanceof FloatingPointArrayProperty) {
            FloatingPointArrayProperty that = (FloatingPointArrayProperty)other2;
            return FloatingPointArrayProperty.numbersEqual((ArrayValue.FloatingPointArray)this, that);
        }
        if (other2 instanceof IntegralArrayProperty) {
            IntegralArrayProperty that = (IntegralArrayProperty)other2;
            return FloatingPointArrayProperty.numbersEqual((ArrayValue.FloatingPointArray)this, (ArrayValue.IntegralArray)that);
        }
        return false;
    }
}

