/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Comparator;
import org.neo4j.helpers.MathUtil;
import org.neo4j.helpers.Strings;
import org.neo4j.kernel.api.properties.ArrayValue;
import org.neo4j.kernel.api.properties.LazyProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.PropertyValueComparison;

public abstract class DefinedProperty
extends Property {
    public static Comparator<DefinedProperty> COMPARATOR = new Comparator<DefinedProperty>(){

        @Override
        public int compare(DefinedProperty left2, DefinedProperty right2) {
            int cmp = left2.propertyKeyId - right2.propertyKeyId;
            if (cmp == 0) {
                return PropertyValueComparison.COMPARE_VALUES.compare(left2.value(), right2.value());
            }
            return cmp;
        }
    };

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    public abstract Object value();

    @Override
    public Object value(Object defaultValue) {
        return this.value();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[propertyKeyId=" + this.propertyKeyId() + ", value=" + this.valueAsString() + "]";
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DefinedProperty) {
            DefinedProperty that = (DefinedProperty)o;
            if (this.propertyKeyId == that.propertyKeyId) {
                if (o instanceof LazyProperty) {
                    return that.valueEquals(this.value());
                }
                return this.hasEqualValue(that);
            }
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.propertyKeyId ^ this.valueHash();
    }

    abstract int valueHash();

    abstract boolean hasEqualValue(DefinedProperty var1);

    @Override
    public String valueAsString() {
        return Strings.prettyPrint(this.value());
    }

    DefinedProperty(int propertyKeyId) {
        super(propertyKeyId);
    }

    static boolean numbersEqual(ArrayValue.IntegralArray lhs, ArrayValue.IntegralArray rhs) {
        int length2 = lhs.length();
        if (length2 != rhs.length()) {
            return false;
        }
        for (int i = 0; i < length2; ++i) {
            if (lhs.longValue(i) == rhs.longValue(i)) continue;
            return false;
        }
        return true;
    }

    static boolean numbersEqual(ArrayValue.FloatingPointArray lhs, ArrayValue.FloatingPointArray rhs) {
        int length2 = lhs.length();
        if (length2 != rhs.length()) {
            return false;
        }
        for (int i = 0; i < length2; ++i) {
            if (lhs.doubleValue(i) == rhs.doubleValue(i)) continue;
            return false;
        }
        return true;
    }

    static boolean numbersEqual(ArrayValue.FloatingPointArray fps, ArrayValue.IntegralArray ins) {
        int length2 = ins.length();
        if (length2 != fps.length()) {
            return false;
        }
        for (int i = 0; i < length2; ++i) {
            if (MathUtil.numbersEqual(fps.doubleValue(i), ins.longValue(i))) continue;
            return false;
        }
        return true;
    }

    public static interface WithLongValue {
        public long longValue();
    }

    public static interface WithDoubleValue {
        public double doubleValue();
    }

    public static interface WithStringValue {
        public String stringValue();
    }
}

