/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.StringArrayProperty;

class CharArrayProperty
extends DefinedProperty {
    final char[] value;

    CharArrayProperty(int propertyKeyId, char[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public char[] value() {
        return (char[])this.value.clone();
    }

    @Override
    public boolean valueEquals(Object other2) {
        return CharArrayProperty.valueEquals(this.value, other2);
    }

    static boolean valueEquals(char[] value, Object other2) {
        if (other2 instanceof char[]) {
            return Arrays.equals(value, (char[])other2);
        }
        if (other2 instanceof Character[]) {
            Character[] that = (Character[])other2;
            if (value.length == that.length) {
                for (int i = 0; i < that.length; ++i) {
                    Character character = that[i];
                    if (character != null && character.charValue() == value[i]) continue;
                    return false;
                }
                return true;
            }
        } else if (other2 instanceof String[]) {
            return CharArrayProperty.eq((String[])other2, value);
        }
        return false;
    }

    @Override
    int valueHash() {
        return CharArrayProperty.hash(this.value);
    }

    static int hash(char[] value) {
        return Arrays.hashCode(value);
    }

    @Override
    boolean hasEqualValue(DefinedProperty other2) {
        if (other2 instanceof CharArrayProperty) {
            CharArrayProperty that = (CharArrayProperty)other2;
            return Arrays.equals(this.value, that.value);
        }
        if (other2 instanceof StringArrayProperty) {
            StringArrayProperty that = (StringArrayProperty)other2;
            return CharArrayProperty.eq(that.value, this.value);
        }
        return false;
    }

    static boolean eq(String[] strings, char[] chars) {
        if (strings.length == chars.length) {
            for (int i = 0; i < strings.length; ++i) {
                String str2 = strings[i];
                if (str2 != null && str2.length() == 1 && str2.charAt(0) == chars[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

