/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.DefinedProperty;

class BooleanArrayProperty
extends DefinedProperty {
    private final boolean[] value;

    BooleanArrayProperty(int propertyKeyId, boolean[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public boolean[] value() {
        return (boolean[])this.value.clone();
    }

    @Override
    public boolean valueEquals(Object other2) {
        return BooleanArrayProperty.valueEquals(this.value, other2);
    }

    static boolean valueEquals(boolean[] value, Object other2) {
        Boolean[] that;
        int length2;
        if (other2 instanceof boolean[]) {
            return Arrays.equals(value, (boolean[])other2);
        }
        if (other2 instanceof Boolean[] && (length2 = value.length) == (that = (Boolean[])other2).length) {
            for (int i = 0; i < length2; ++i) {
                Boolean bool = that[i];
                if (bool != null && bool == value[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    int valueHash() {
        return BooleanArrayProperty.hash(this.value);
    }

    static int hash(boolean[] value) {
        return Arrays.hashCode(value);
    }

    @Override
    boolean hasEqualValue(DefinedProperty that) {
        return that instanceof BooleanArrayProperty && Arrays.equals(this.value, ((BooleanArrayProperty)that).value);
    }
}

