/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.proc;

public class Neo4jTypes {
    public static final AnyType NTAny = new AnyType();
    public static final TextType NTString = new TextType();
    public static final NumberType NTNumber = new NumberType();
    public static final IntegerType NTInteger = new IntegerType();
    public static final FloatType NTFloat = new FloatType();
    public static final BooleanType NTBoolean = new BooleanType();
    public static final MapType NTMap = new MapType();
    public static final NodeType NTNode = new NodeType();
    public static final RelationshipType NTRelationship = new RelationshipType();
    public static final PathType NTPath = new PathType();

    public static ListType NTList(AnyType innerType) {
        return new ListType(innerType);
    }

    public static class PathType
    extends AnyType {
        public PathType() {
            super("PATH?");
        }
    }

    public static class RelationshipType
    extends MapType {
        public RelationshipType() {
            super("RELATIONSHIP?");
        }
    }

    public static class NodeType
    extends MapType {
        public NodeType() {
            super("NODE?");
        }
    }

    public static class MapType
    extends AnyType {
        public MapType() {
            super("MAP?");
        }

        protected MapType(String name2) {
            super(name2);
        }
    }

    public static class ListType
    extends AnyType {
        private final AnyType innerType;

        public ListType(AnyType innerType) {
            super("LIST? OF " + innerType.toString());
            this.innerType = innerType;
        }

        public AnyType innerType() {
            return this.innerType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListType listType = (ListType)o;
            return this.innerType.equals(listType.innerType);
        }

        public int hashCode() {
            return this.innerType.hashCode();
        }
    }

    public static class BooleanType
    extends AnyType {
        public BooleanType() {
            super("BOOLEAN?");
        }
    }

    public static class FloatType
    extends NumberType {
        public FloatType() {
            super("FLOAT?");
        }
    }

    public static class IntegerType
    extends NumberType {
        public IntegerType() {
            super("INTEGER?");
        }
    }

    public static class NumberType
    extends AnyType {
        public NumberType() {
            super("NUMBER?");
        }

        protected NumberType(String name2) {
            super(name2);
        }
    }

    public static class TextType
    extends AnyType {
        public TextType() {
            super("STRING?");
        }
    }

    public static class AnyType {
        private final String name;

        public AnyType() {
            this("ANY?");
        }

        protected AnyType(String name2) {
            this.name = name2;
        }

        public String toString() {
            return this.name;
        }
    }
}

