/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.impl.api.index.UpdateMode;

public class NodePropertyUpdate {
    private final long nodeId;
    private final int propertyKeyId;
    private final Object valueBefore;
    private final Object valueAfter;
    private final UpdateMode updateMode;
    private final long[] labelsBefore;
    private final long[] labelsAfter;

    private NodePropertyUpdate(long nodeId, int propertyKeyId, Object valueBefore, long[] labelsBefore, Object valueAfter, long[] labelsAfter, UpdateMode updateMode) {
        this.nodeId = nodeId;
        this.propertyKeyId = propertyKeyId;
        this.valueBefore = valueBefore;
        this.labelsBefore = labelsBefore;
        this.valueAfter = valueAfter;
        this.labelsAfter = labelsAfter;
        this.updateMode = updateMode;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public int getPropertyKeyId() {
        return this.propertyKeyId;
    }

    public Object getValueBefore() {
        return this.valueBefore;
    }

    public Object getValueAfter() {
        return this.valueAfter;
    }

    public int getNumberOfLabelsBefore() {
        return this.labelsBefore.length;
    }

    public int getLabelBefore(int i) {
        return (int)this.labelsBefore[i];
    }

    public int getNumberOfLabelsAfter() {
        return this.labelsAfter.length;
    }

    public int getLabelAfter(int i) {
        return (int)this.labelsAfter[i];
    }

    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public boolean forLabel(long labelId) {
        return this.updateMode.forLabel(this.labelsBefore, this.labelsAfter, labelId);
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder(this.getClass().getSimpleName()).append("[").append(this.nodeId).append(", prop:").append(this.propertyKeyId).append(" ");
        switch (this.updateMode) {
            case ADDED: {
                result2.append("add:").append(this.valueAfter);
                break;
            }
            case CHANGED: {
                result2.append("change:").append(this.valueBefore).append(" => ").append(this.valueAfter);
                break;
            }
            case REMOVED: {
                result2.append("remove:").append(this.valueBefore);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.updateMode.toString());
            }
        }
        result2.append(", labelsBefore:").append(Arrays.toString(this.labelsBefore));
        result2.append(", labelsAfter:").append(Arrays.toString(this.labelsAfter));
        return result2.append("]").toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + Arrays.hashCode(this.labelsBefore);
        result2 = 31 * result2 + Arrays.hashCode(this.labelsAfter);
        result2 = 31 * result2 + (int)(this.nodeId ^ this.nodeId >>> 32);
        result2 = 31 * result2 + this.propertyKeyId;
        result2 = 31 * result2 + this.updateMode.hashCode();
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodePropertyUpdate other2 = (NodePropertyUpdate)obj;
        return Arrays.equals(this.labelsBefore, other2.labelsBefore) && Arrays.equals(this.labelsAfter, other2.labelsAfter) && this.nodeId == other2.nodeId && this.propertyKeyId == other2.propertyKeyId && this.updateMode == other2.updateMode && NodePropertyUpdate.propertyValuesEqual(this.valueBefore, other2.valueBefore) && NodePropertyUpdate.propertyValuesEqual(this.valueAfter, other2.valueAfter);
    }

    public static boolean propertyValuesEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof boolean[] && b instanceof boolean[]) {
            return Arrays.equals((boolean[])a, (boolean[])b);
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return Arrays.equals((byte[])a, (byte[])b);
        }
        if (a instanceof short[] && b instanceof short[]) {
            return Arrays.equals((short[])a, (short[])b);
        }
        if (a instanceof int[] && b instanceof int[]) {
            return Arrays.equals((int[])a, (int[])b);
        }
        if (a instanceof long[] && b instanceof long[]) {
            return Arrays.equals((long[])a, (long[])b);
        }
        if (a instanceof char[] && b instanceof char[]) {
            return Arrays.equals((char[])a, (char[])b);
        }
        if (a instanceof float[] && b instanceof float[]) {
            return Arrays.equals((float[])a, (float[])b);
        }
        if (a instanceof double[] && b instanceof double[]) {
            return Arrays.equals((double[])a, (double[])b);
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            return Arrays.equals((Object[])a, (Object[])b);
        }
        return a.equals(b);
    }

    public static NodePropertyUpdate add(long nodeId, int propertyKeyId, Object value, long[] labels2) {
        return new NodePropertyUpdate(nodeId, propertyKeyId, null, PrimitiveLongCollections.EMPTY_LONG_ARRAY, value, labels2, UpdateMode.ADDED);
    }

    public static NodePropertyUpdate change(long nodeId, int propertyKeyId, Object valueBefore, long[] labelsBefore, Object valueAfter, long[] labelsAfter) {
        return new NodePropertyUpdate(nodeId, propertyKeyId, valueBefore, labelsBefore, valueAfter, labelsAfter, UpdateMode.CHANGED);
    }

    public static NodePropertyUpdate remove(long nodeId, int propertyKeyId, Object value, long[] labels2) {
        return new NodePropertyUpdate(nodeId, propertyKeyId, value, labels2, null, PrimitiveLongCollections.EMPTY_LONG_ARRAY, UpdateMode.REMOVED);
    }
}

