/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.verification;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.verification.DuplicateCheckingCollector;
import org.neo4j.kernel.api.impl.schema.verification.UniquenessVerifier;
import org.neo4j.kernel.api.index.PropertyAccessor;

public class PartitionedUniquenessVerifier
implements UniquenessVerifier {
    private final List<PartitionSearcher> searchers;

    public PartitionedUniquenessVerifier(List<PartitionSearcher> searchers) {
        this.searchers = searchers;
    }

    @Override
    public void verify(PropertyAccessor accessor, int propKeyId) throws IndexEntryConflictException, IOException {
        for (String field2 : this.allFields()) {
            BytesRef termsRef;
            if ("id".equals(field2)) continue;
            TermsEnum terms = LuceneDocumentStructure.originalTerms(this.termsForField(field2), field2);
            while ((termsRef = terms.next()) != null) {
                if (terms.docFreq() <= 1) continue;
                TermQuery query = new TermQuery(new Term(field2, termsRef));
                this.searchForDuplicates(query, accessor, propKeyId);
            }
        }
    }

    @Override
    public void verify(PropertyAccessor accessor, int propKeyId, List<Object> updatedPropertyValues) throws IndexEntryConflictException, IOException {
        for (Object propertyValue : updatedPropertyValues) {
            Query query = LuceneDocumentStructure.newSeekQuery(propertyValue);
            this.searchForDuplicates(query, accessor, propKeyId);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll(this.searchers);
    }

    private Terms termsForField(String fieldName) throws IOException {
        ArrayList<Terms> terms = new ArrayList<Terms>();
        ArrayList<ReaderSlice> readerSlices = new ArrayList<ReaderSlice>();
        for (LeafReader leafReader : this.allLeafReaders()) {
            Fields fields = leafReader.fields();
            Terms leafTerms = fields.terms(fieldName);
            if (leafTerms == null) continue;
            ReaderSlice readerSlice = new ReaderSlice(0, Math.toIntExact(leafTerms.size()), 0);
            terms.add(leafTerms);
            readerSlices.add(readerSlice);
        }
        Terms[] termsArray = terms.toArray(new Terms[terms.size()]);
        ReaderSlice[] readerSlicesArray = readerSlices.toArray(new ReaderSlice[readerSlices.size()]);
        return new MultiTerms(termsArray, readerSlicesArray);
    }

    private void searchForDuplicates(Query query, PropertyAccessor accessor, int propertyKeyId) throws IOException, IndexEntryConflictException {
        try {
            DuplicateCheckingCollector collector = new DuplicateCheckingCollector(accessor, propertyKeyId);
            for (PartitionSearcher searcher : this.searchers) {
                searcher.getIndexSearcher().search(query, collector);
            }
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IndexEntryConflictException) {
                throw (IndexEntryConflictException)cause;
            }
            throw e;
        }
    }

    private Set<String> allFields() throws IOException {
        HashSet<String> allFields = new HashSet<String>();
        for (LeafReader leafReader : this.allLeafReaders()) {
            Iterables.addAll(allFields, leafReader.fields());
        }
        return allFields;
    }

    private List<LeafReader> allLeafReaders() {
        return this.searchers.stream().map(PartitionSearcher::getIndexSearcher).map(IndexSearcher::getIndexReader).flatMap(indexReader -> indexReader.leaves().stream()).map(LeafReaderContext::reader).collect(Collectors.toList());
    }
}

