/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.sampler;

import org.neo4j.helpers.TaskControl;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;

abstract class LuceneIndexSampler
implements IndexSampler {
    private final TaskControl executionTicket;

    LuceneIndexSampler(TaskControl taskControl) {
        this.executionTicket = taskControl;
    }

    protected abstract IndexSample performSampling() throws IndexNotFoundKernelException;

    @Override
    public final IndexSample sampleIndex() throws IndexNotFoundKernelException {
        try {
            IndexSample indexSample = this.performSampling();
            return indexSample;
        }
        finally {
            this.completeSampling();
        }
    }

    void checkCancellation() throws IndexNotFoundKernelException {
        if (this.executionTicket.cancellationRequested()) {
            throw new IndexNotFoundKernelException("Index dropped while sampling.");
        }
    }

    private void completeSampling() {
        this.executionTicket.close();
    }
}

