/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.schema.populator.UniqueLuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;
import org.neo4j.storageengine.api.schema.IndexSample;

public class UniqueLuceneIndexPopulator
extends LuceneIndexPopulator {
    private final int propertyKeyId;
    private final UniqueIndexSampler sampler;

    public UniqueLuceneIndexPopulator(LuceneSchemaIndex index, IndexDescriptor descriptor) {
        super(index);
        this.propertyKeyId = descriptor.getPropertyKeyId();
        this.sampler = new UniqueIndexSampler();
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
        this.luceneIndex.verifyUniqueness(accessor, this.propertyKeyId);
    }

    @Override
    public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) throws IOException {
        return new UniqueLuceneIndexPopulatingUpdater(this.writer, this.propertyKeyId, this.luceneIndex, accessor, this.sampler);
    }

    @Override
    public void includeSample(NodePropertyUpdate update2) {
        this.sampler.increment(1L);
    }

    @Override
    public IndexSample sampleResult() {
        return this.sampler.result();
    }
}

