/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;

public class UniqueLuceneIndexPopulatingUpdater
extends LuceneIndexPopulatingUpdater {
    private final int propertyKeyId;
    private final LuceneSchemaIndex luceneIndex;
    private final PropertyAccessor propertyAccessor;
    private final UniqueIndexSampler sampler;
    private final List<Object> updatedPropertyValues = new ArrayList<Object>();

    public UniqueLuceneIndexPopulatingUpdater(LuceneIndexWriter writer, int propertyKeyId, LuceneSchemaIndex luceneIndex, PropertyAccessor propertyAccessor, UniqueIndexSampler sampler) {
        super(writer);
        this.propertyKeyId = propertyKeyId;
        this.luceneIndex = luceneIndex;
        this.propertyAccessor = propertyAccessor;
        this.sampler = sampler;
    }

    @Override
    protected void added(NodePropertyUpdate update2) {
        this.sampler.increment(1L);
        this.updatedPropertyValues.add(update2.getValueAfter());
    }

    @Override
    protected void changed(NodePropertyUpdate update2) {
        this.updatedPropertyValues.add(update2.getValueAfter());
    }

    @Override
    protected void removed(NodePropertyUpdate update2) {
        this.sampler.increment(-1L);
    }

    @Override
    public void close() throws IOException, IndexEntryConflictException {
        this.luceneIndex.verifyUniqueness(this.propertyAccessor, this.propertyKeyId, this.updatedPropertyValues);
    }
}

