/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;

public class NonUniqueLuceneIndexPopulatingUpdater
extends LuceneIndexPopulatingUpdater {
    private final NonUniqueIndexSampler sampler;

    public NonUniqueLuceneIndexPopulatingUpdater(LuceneIndexWriter writer, NonUniqueIndexSampler sampler) {
        super(writer);
        this.sampler = sampler;
    }

    @Override
    protected void added(NodePropertyUpdate update2) {
        String encodedValue = LuceneDocumentStructure.encodedStringValue(update2.getValueAfter());
        this.sampler.include(encodedValue);
    }

    @Override
    protected void changed(NodePropertyUpdate update2) {
        String encodedValueBefore = LuceneDocumentStructure.encodedStringValue(update2.getValueBefore());
        this.sampler.exclude(encodedValueBefore);
        String encodedValueAfter = LuceneDocumentStructure.encodedStringValue(update2.getValueAfter());
        this.sampler.include(encodedValueAfter);
    }

    @Override
    protected void removed(NodePropertyUpdate update2) {
        String removedValue = LuceneDocumentStructure.encodedStringValue(update2.getValueBefore());
        this.sampler.exclude(removedValue);
    }

    @Override
    public void close() {
    }
}

