/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndex;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.NodePropertyUpdate;

public abstract class LuceneIndexPopulator
implements IndexPopulator {
    protected LuceneSchemaIndex luceneIndex;
    protected LuceneIndexWriter writer;

    LuceneIndexPopulator(LuceneSchemaIndex luceneIndex) {
        this.luceneIndex = luceneIndex;
    }

    @Override
    public void create() throws IOException {
        this.luceneIndex.create();
        this.luceneIndex.open();
        this.writer = this.luceneIndex.getIndexWriter();
    }

    @Override
    public void drop() throws IOException {
        this.luceneIndex.drop();
    }

    @Override
    public void add(Collection<NodePropertyUpdate> updates) throws IndexEntryConflictException, IOException {
        Iterator documents = updates.stream().map(LuceneIndexPopulator::updateAsDocument).iterator();
        this.writer.addDocuments(() -> documents);
    }

    @Override
    public void close(boolean populationCompletedSuccessfully) throws IOException {
        try {
            if (populationCompletedSuccessfully) {
                this.luceneIndex.markAsOnline();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeAllSilently((AutoCloseable[])new LuceneSchemaIndex[]{this.luceneIndex});
            throw throwable;
        }
        IOUtils.closeAllSilently((AutoCloseable[])new LuceneSchemaIndex[]{this.luceneIndex});
    }

    @Override
    public void markAsFailed(String failure) throws IOException {
        this.luceneIndex.markAsFailed(failure);
    }

    private static Document updateAsDocument(NodePropertyUpdate update2) {
        return LuceneDocumentStructure.documentRepresentingProperty(update2.getNodeId(), update2.getValueAfter());
    }
}

