/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;

public abstract class LuceneIndexPopulatingUpdater
implements IndexUpdater {
    private final LuceneIndexWriter writer;

    public LuceneIndexPopulatingUpdater(LuceneIndexWriter writer) {
        this.writer = writer;
    }

    @Override
    public void process(NodePropertyUpdate update2) throws IOException, IndexEntryConflictException {
        long nodeId = update2.getNodeId();
        switch (update2.getUpdateMode()) {
            case ADDED: {
                this.added(update2);
                this.writer.updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId), LuceneDocumentStructure.documentRepresentingProperty(nodeId, update2.getValueAfter()));
                break;
            }
            case CHANGED: {
                this.changed(update2);
                this.writer.updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId), LuceneDocumentStructure.documentRepresentingProperty(nodeId, update2.getValueAfter()));
                break;
            }
            case REMOVED: {
                this.removed(update2);
                this.writer.deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown update mode " + (Object)((Object)update2.getUpdateMode()));
            }
        }
    }

    @Override
    public final void remove(PrimitiveLongSet nodeIds) {
        throw new UnsupportedOperationException("Should not remove from populating index");
    }

    protected abstract void added(NodePropertyUpdate var1);

    protected abstract void changed(NodePropertyUpdate var1);

    protected abstract void removed(NodePropertyUpdate var1);
}

