/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.CorruptIndexException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.IndexStorageFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndex;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexProviderFactory;
import org.neo4j.kernel.api.impl.schema.populator.NonUniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.impl.schema.populator.UniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.participant.SchemaIndexMigrator;

public class LuceneSchemaIndexProvider
extends SchemaIndexProvider {
    private final Map<Long, String> failures = new HashMap<Long, String>();
    private final IndexStorageFactory indexStorageFactory;

    public LuceneSchemaIndexProvider(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory, File storeDir) {
        super(LuceneSchemaIndexProviderFactory.PROVIDER_DESCRIPTOR, 1);
        File schemaIndexStoreFolder = this.getSchemaIndexStoreDirectory(storeDir);
        this.indexStorageFactory = new IndexStorageFactory(directoryFactory, fileSystem, schemaIndexStoreFolder);
    }

    LuceneSchemaIndexProvider(IndexStorageFactory indexStorageFactory) {
        super(LuceneSchemaIndexProviderFactory.PROVIDER_DESCRIPTOR, 1);
        this.indexStorageFactory = indexStorageFactory;
    }

    @Override
    public IndexPopulator getPopulator(long indexId, IndexDescriptor descriptor, IndexConfiguration config, IndexSamplingConfig samplingConfig) {
        LuceneSchemaIndex luceneIndex = ((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create().withIndexConfig(config).withSamplingConfig(samplingConfig).withIndexStorage(this.getIndexStorage(indexId))).withWriterConfig(IndexWriterConfigs::population).build();
        if (config.isUnique()) {
            return new UniqueLuceneIndexPopulator(luceneIndex, descriptor);
        }
        return new NonUniqueLuceneIndexPopulator(luceneIndex, samplingConfig);
    }

    @Override
    public IndexAccessor getOnlineAccessor(long indexId, IndexConfiguration config, IndexSamplingConfig samplingConfig) throws IOException {
        LuceneSchemaIndex luceneIndex = ((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create().withIndexConfig(config).withSamplingConfig(samplingConfig).withIndexStorage(this.getIndexStorage(indexId))).build();
        luceneIndex.open();
        return new LuceneIndexAccessor(luceneIndex);
    }

    @Override
    public void shutdown() throws Throwable {
    }

    @Override
    public InternalIndexState getInitialState(long indexId) {
        try {
            PartitionedIndexStorage indexStorage = this.getIndexStorage(indexId);
            String failure = indexStorage.getStoredIndexFailure();
            if (failure != null) {
                this.failures.put(indexId, failure);
                return InternalIndexState.FAILED;
            }
            return this.indexIsOnline(indexStorage) ? InternalIndexState.ONLINE : InternalIndexState.POPULATING;
        }
        catch (CorruptIndexException e) {
            return InternalIndexState.FAILED;
        }
        catch (FileNotFoundException e) {
            this.failures.put(indexId, "File not found: " + e.getMessage());
            return InternalIndexState.FAILED;
        }
        catch (EOFException e) {
            this.failures.put(indexId, "EOF encountered: " + e.getMessage());
            return InternalIndexState.FAILED;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, LabelScanStoreProvider labelScanStoreProvider) {
        return new SchemaIndexMigrator(fs, this, labelScanStoreProvider);
    }

    @Override
    public String getPopulationFailure(long indexId) throws IllegalStateException {
        String failure = this.getIndexStorage(indexId).getStoredIndexFailure();
        if (failure == null) {
            failure = this.failures.get(indexId);
        }
        if (failure == null) {
            throw new IllegalStateException("Index " + indexId + " isn't failed");
        }
        return failure;
    }

    private PartitionedIndexStorage getIndexStorage(long indexId) {
        return this.indexStorageFactory.indexStorageOf(indexId);
    }

    private boolean indexIsOnline(PartitionedIndexStorage indexStorage) throws IOException {
        try (LuceneSchemaIndex index = ((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create().withIndexStorage(indexStorage)).build();){
            if (index.exists()) {
                index.open();
                boolean bl = index.isOnline();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

