/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.neo4j.function.Factory;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.partition.IndexPartition;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.reader.PartitionedIndexReader;
import org.neo4j.kernel.api.impl.schema.reader.SimpleIndexReader;
import org.neo4j.kernel.api.impl.schema.verification.PartitionedUniquenessVerifier;
import org.neo4j.kernel.api.impl.schema.verification.SimpleUniquenessVerifier;
import org.neo4j.kernel.api.impl.schema.verification.UniquenessVerifier;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.impl.schema.writer.PartitionedIndexWriter;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexReader;

public class LuceneSchemaIndex
extends AbstractLuceneIndex {
    private static final String KEY_STATUS = "status";
    private static final String ONLINE = "online";
    private static final Map<String, String> ONLINE_COMMIT_USER_DATA = Collections.singletonMap("status", "online");
    private final IndexConfiguration config;
    private final IndexSamplingConfig samplingConfig;
    private final TaskCoordinator taskCoordinator = new TaskCoordinator(10L, TimeUnit.MILLISECONDS);

    public LuceneSchemaIndex(PartitionedIndexStorage indexStorage, IndexConfiguration config, IndexSamplingConfig samplingConfig, Factory<IndexWriterConfig> writerConfigFactory) {
        super(indexStorage, writerConfigFactory);
        this.config = config;
        this.samplingConfig = samplingConfig;
    }

    public LuceneIndexWriter getIndexWriter() throws IOException {
        this.ensureOpen();
        return new PartitionedIndexWriter(this);
    }

    public IndexReader getIndexReader() throws IOException {
        this.ensureOpen();
        this.partitionsLock.lock();
        try {
            List<IndexPartition> partitions = this.getPartitions();
            IndexReader indexReader = this.hasSinglePartition(partitions) ? this.createSimpleReader(partitions) : this.createPartitionedReader(partitions);
            return indexReader;
        }
        finally {
            this.partitionsLock.unlock();
        }
    }

    public void verifyUniqueness(PropertyAccessor accessor, int propertyKeyId) throws IOException, IndexEntryConflictException {
        try (UniquenessVerifier verifier = this.createUniquenessVerifier();){
            verifier.verify(accessor, propertyKeyId);
        }
    }

    public void verifyUniqueness(PropertyAccessor accessor, int propertyKeyId, List<Object> updatedPropertyValues) throws IOException, IndexEntryConflictException {
        try (UniquenessVerifier verifier = this.createUniquenessVerifier();){
            verifier.verify(accessor, propertyKeyId, updatedPropertyValues);
        }
    }

    @Override
    public void drop() throws IOException {
        this.taskCoordinator.cancel();
        try {
            this.taskCoordinator.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while waiting for concurrent tasks to complete.", e);
        }
        super.drop();
    }

    public boolean isOnline() throws IOException {
        this.ensureOpen();
        IndexPartition partition2 = this.getFirstPartition(this.getPartitions());
        Directory directory = partition2.getDirectory();
        try (DirectoryReader reader = DirectoryReader.open(directory);){
            Map<String, String> userData = reader.getIndexCommit().getUserData();
            boolean bl = ONLINE.equals(userData.get(KEY_STATUS));
            return bl;
        }
    }

    public void markAsOnline() throws IOException {
        this.ensureOpen();
        this.commitCloseLock.lock();
        try {
            IndexPartition partition2 = this.getFirstPartition(this.getPartitions());
            IndexWriter indexWriter = partition2.getIndexWriter();
            indexWriter.setCommitData(ONLINE_COMMIT_USER_DATA);
            this.flush();
        }
        finally {
            this.commitCloseLock.unlock();
        }
    }

    public void markAsFailed(String failure) throws IOException {
        this.indexStorage.storeIndexFailure(failure);
    }

    private UniquenessVerifier createUniquenessVerifier() throws IOException {
        this.ensureOpen();
        this.maybeRefreshBlocking();
        List<IndexPartition> partitions = this.getPartitions();
        return this.hasSinglePartition(partitions) ? this.createSimpleUniquenessVerifier(partitions) : this.createPartitionedUniquenessVerifier(partitions);
    }

    private SimpleIndexReader createSimpleReader(List<IndexPartition> partitions) throws IOException {
        IndexPartition singlePartition = this.getFirstPartition(partitions);
        return new SimpleIndexReader(singlePartition.acquireSearcher(), this.config, this.samplingConfig, this.taskCoordinator);
    }

    private UniquenessVerifier createSimpleUniquenessVerifier(List<IndexPartition> partitions) throws IOException {
        IndexPartition singlePartition = this.getFirstPartition(partitions);
        PartitionSearcher partitionSearcher = singlePartition.acquireSearcher();
        return new SimpleUniquenessVerifier(partitionSearcher);
    }

    private PartitionedIndexReader createPartitionedReader(List<IndexPartition> partitions) throws IOException {
        List<PartitionSearcher> searchers = LuceneSchemaIndex.acquireSearchers(partitions);
        return new PartitionedIndexReader(searchers, this.config, this.samplingConfig, this.taskCoordinator);
    }

    private UniquenessVerifier createPartitionedUniquenessVerifier(List<IndexPartition> partitions) throws IOException {
        List<PartitionSearcher> searchers = LuceneSchemaIndex.acquireSearchers(partitions);
        return new PartitionedUniquenessVerifier(searchers);
    }
}

